#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "nav_switch.h"

//#include "part2.h"
//#include "part3.h"
#include "part4_led.h"
//#include "lidar_theremin.h"

Serial pc(USBTX, USBRX);
//RawSerial dev(p9,p10);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
RGBLed led = RGBLed(p21, p22, p23);

float p = 0.5;
Color colors[] = { _red(1.0), _pink(1.0), _orange(1.0), _yellow(1.0) };

uLCD_4DGL lcd(p28,p27,p30);

Thread led_thread;
Thread lcd_thread1;
Thread lcd_thread2;
Thread audio_thread;

//void changeColor() {
//    while (dev.readable()) {
//        char c = dev.getc();
//        
//        if (c == 'r') {
//            colors[0] = _red(p);
//            colors[1] = _pink(p);
//            colors[2] = _orange(p);
//            colors[3] = _yellow(p);
//        } else if (c == 'b') {
//            colors[0] = _teal(p);
//            colors[1] = _light_blue(p);
//            colors[2] = _blue(p);
//            colors[3] = _purple(p);
//        } else if (c == 'g') {
//            colors[0] = _yellow(p);
//            colors[1] = _light_green(p);
//            colors[2] = _green(p);
//            colors[3] = _teal(p);
//        }
//    }
//}

void led_handler() {
    Color c = colors[0];
    int i = 0;
    while (1) {
        led.write(c.red*p, c.green*p, c.blue*p);
        i = (i + 1) % 4;
        c = colors[i];
        
        Thread::wait(500);
    }
}

//Mutex lcd_mutex;
Semaphore sem(1);


void lcd1_handler() {
    int i = 0;
    while (1) {
//        lcd_mutex.lock();
        sem.wait();
        lcd.locate(0, 0);
        lcd.printf("Counter: %d", i);
//        lcd_mutex.unlock();
        sem.release();
        
        i++;
        Thread::wait(1000);
    }
}

void lcd2_handler() {
    int i,k, offset;
    double s,a;
    k = 1;
    offset = 50;
//    lcd_mutex.lock();
    sem.wait();
    lcd.rectangle(89,0,127,17,1);
//    lcd_mutex.unlock();
    sem.release();
    
    while(1) {       // thread loop
//        v = 1; 
//        lcd_mutex.lock();
        sem.wait();
        for (i=0; i<127; i++) {
            s = 8 * sin((long double)(i+k) /5);   // pixel to print
            a = 8 * sin((long double)(i+k-1) /5); // old pixel to erase
            lcd.pixel(i,offset + (int)a, BLACK);           // erase pixel
            lcd.pixel(i,offset + (int)s, WHITE);           // print pixel
        }
//        lcd_mutex.unlock();
        sem.release();
        k++;
        Thread::wait(100);   // value of pot1 / 100   
    }
}

SDFileSystem sd(p5, p6, p7, p8, "sd");
AnalogOut DACout(p18);
wave_player waver(&DACout);
bool play_audio = true;

void audio_handler() {
    FILE *wave_file;
    myled2 = !myled2;
//    printf("\n\n\nHello, wave world!\n");
//    myled4 = !myled4;
    while (play_audio) {
        myled4 = !myled4;
        wave_file=fopen("/sd/sample.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        Thread::wait(1000);
    }
}

Nav_Switch nav(p15, p12, p16, p11, p17);

int main() {
//    run_part2();
//    run_part2_EC();
//    run_lidar_theremin();
    
//    run_part3();

    pc.baud(9600);
//    dev.baud(9600);
    
    led_thread.start(led_handler);
    lcd.cls();
    lcd_thread1.start(lcd1_handler);
    lcd_thread2.start(lcd2_handler);
    audio_thread.start(audio_handler);
    
//    dev.attach(&changeColor, Serial::RxIrq);

    while (1) {
        myled1 = !myled1;
        if (nav.fire()) {
            play_audio = !play_audio;
        } else if (nav.up() && p < 1.0f) {
            p += 0.1f;
        } else if (nav.down() && p > 0.0f) {
            p -= 0.1f;
        } else if (nav.left()) {
            colors[0] = _red(1.0);
            colors[1] = _pink(1.0);
            colors[2] = _orange(1.0);
            colors[3] = _yellow(1.0);
        } else if (nav.right()) {
            colors[0] = _teal(1.0);
            colors[1] = _light_blue(1.0);
            colors[2] = _blue(1.0);
            colors[3] = _purple(1.0);
        }

        Thread::wait(100);
    }
}