#include "mbed.h"
#include "XNucleo53L0A1.h"
#include <stdio.h>
Serial pc(USBTX,USBRX);
DigitalOut shdn(p25);
// This VL53L0X board test application performs a range measurement in polling mode
// Use 3.3(Vout) for Vin, p28 for SDA, p27 for SCL, P26 for shdn on mbed LPC1768

//I2C sensor pins
#define VL53L0_I2C_SDA   p28
#define VL53L0_I2C_SCL   p27

static XNucleo53L0A1 *board=NULL;

DigitalOut audio(p26); //output to speaker amp or audio jack
DigitalOut led(LED1); 
DigitalOut led2(LED2);

//Timeout cycle;
Ticker cycle;
 
volatile int half_cycle_time = 1;
 
//two calls to this interrupt routine generates a square wave
void toggle_interrupt()
{
    if (half_cycle_time>22000) audio=0; //mute if nothing in range
    else audio = !audio; //toggle to make half a square wave
    led = !led;
    cycle.detach();
    //update time for interrupt activation -change frequency of square wave
    cycle.attach_us(&toggle_interrupt, half_cycle_time);
}

uint32_t distance;
void newdist()
{
    //update frequency based on new sonar data
    led2 = !led2;
    half_cycle_time = (distance*10)<<3;
}  

//Set the trigger pin to p6 and the echo pin to p7
//have updates every .07 seconds and a timeout after 1
//second, and call newdist when the distance changes
int run_lidar_theremin()
{
    int status;
    DevI2C *device_i2c = new DevI2C(VL53L0_I2C_SDA, VL53L0_I2C_SCL);
    /* creates the 53L0A1 expansion board singleton obj */
    board = XNucleo53L0A1::instance(device_i2c, A2, D8, D2);
    shdn = 0; //must reset sensor for an mbed reset to work
    wait(0.1);
    shdn = 1;
    wait(0.1);
    /* init the 53L0A1 board with default values */
    status = board->init_board();
    
    while (status) {
        pc.printf("Failed to init board! \r\n");
        status = board->init_board();
    }
    //loop taking and printing distance
    
    audio = 0;
    led = 0;
    cycle.attach(&toggle_interrupt, half_cycle_time);
    while(1) {
        //Do something else here
        status = board->sensor_centre->get_distance(&distance);
        newdist();
        pc.printf("distance %d", distance);    
        //call checkDistance() as much as possible, as this is where
        //the class checks if dist needs to be called.
    }
}
