#include "mbed.h"

class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};
 
// Setup the watchdog timer
Watchdog wdt;

DigitalIn pb(p22);
DigitalOut myled(p26);

int prev;

int run_watchdogEC() {
    wdt.kick(10.0);
    
    prev = pb;
    
    int count = 0;
    
    while(1) {
        if (prev != pb) {
            count++;
        }
        prev = pb;
        myled = !pb;
        
        if (count == 2) {
            while (1) {
                ;
            }
        }
        
        wdt.kick();
    }
}