//    AREA asm_func, CODE, READONLY
//; Export my_asm function location so that C compiler can find it and link
//    EXPORT assembly_ec
//assembly_ec
//;
//; ARM Assembly language function to set LED1 bit to a value passed from C   
//; Pushbutton is on GPIO port 2.4 (connected to p22)
//; Led is on GPIO port 2.0 (connected to p26)
//; See Chapter 9 in the LPC1768 User Manual
//; for all of the GPIO register info and addresses
//; Pinnames.h has the mbed modules pin port and bit connections
//;
//
//; Load GPIO Port 2 base address in register R1
//    LDR     R1, =0x2009C040 ; 0x2009C040 = GPIO port 2 base address
//; Load value from pushbutton into register R0
//    LDR     R0, R1
//; Move bit mask in register R2 for bit 4 only
//    MOV.W   R2, #0x000010   ; 0x000010 = 1<<4 all "0"s with a "1" in bit 4
//; See if pushbutton is pressed
//    CMP     R0, #0
//; (If-Then-Else) on next two instructions using equal cond from the zero flag
//    ITE EQ
//; STORE if EQ - clear led 1 port bit using GPIO FIOCLR register and mask
//    STREQ   R2, [R1,#0x58]  ; if==0, set LED1 bit
//; STORE if NE - set led 1 port bit using GPIO FIOSET register and mask
//    STRNE   R2, [R1,#0x5C]  ; if==1, clear LED1 bit
//; Return to C using link register (Branch indirect using LR - a return)
//    BX      LR
//    END