#include "mbed.h"
#include "rtos.h"

void led_blink(PinName led_name) {
    DigitalOut led(led_name);
    while (1) {
        Thread::wait(1000);
        led = !led;
    }
}

void notify_completion(bool success) {
    if (success) {
        printf("{success}\n");
    } else {
        printf("{failure}\n");
    }
    
    printf("{end}\n");
    led_blink(success?LED2:LED4);
}

#define FILENAME      "/local/out.txt"
#define TEST_STRING   "Hello World!"

FILE* test_open(const char* mode) {
    FILE *f;
    f = fopen(FILENAME, mode);
    if (f == NULL) {
        printf("Error opening file\n");
        notify_completion(false);
    }
    
    return f;
}

void test_write(FILE* f, char* str, int str_len) {
    int n = fprintf(f, str);
    if (n != str_len) {
        printf("Error writing file\n");
        notify_completion(false);
    }
}

void test_read(FILE* f, char* str, int str_len) {
    int n = fread(str, sizeof(unsigned char), str_len, f);
    if (n != str_len) {
        printf("Error reading file\n");
        notify_completion(false);
    }
}

void test_close(FILE* f) {
    int rc = fclose(f);
    if (rc != 0) {
        printf("Error closing file\n");
        notify_completion(false);
    }
}

void test_localfilesystem(void const *argument) {
    LocalFileSystem local("local");
    
    FILE *f;
    char* str = TEST_STRING;
    char* buffer = (char*) malloc(sizeof(unsigned char)*strlen(TEST_STRING));
    int str_len = strlen(TEST_STRING);
    
    // Write
    f = test_open("w");
    test_write(f, str, str_len);
    test_close(f);
    
    // Read
    f = test_open("r");
    test_read(f, buffer, str_len);
    test_close(f);
    
    // Check the two strings are equal
    notify_completion((strncmp(buffer, str, str_len) == 0));
}

int main() {
    Thread t(test_localfilesystem);
    led_blink(LED1);
}
