/* Copyright (c) 2012 mbed.org */
#ifndef FIR_F32_H
#define FIR_F32_H 

#include <stdint.h>
#include "arm_math.h"

namespace dsp {

template<uint16_t num_taps, uint32_t block_size=32>
class FIR_f32 {
public:
    FIR_f32(const float32_t *coeff) {
        arm_fir_init_f32(&fir, num_taps, (float32_t*)coeff, fir_state, block_size);
    }
    
    void process(float *signal) {
        arm_fir_f32(&fir, signal, signal, block_size);
    }
    
    void reset(void) {
        memset(fir_state, 0, sizeof(fir_state));
    }

private:
    arm_fir_instance_f32 fir;
    float32_t fir_state[block_size + num_taps - 1];
};

}
#endif
