/* Copyright (c) 2012 mbed.org */
#ifndef SINE_F32_H
#define SINE_F32_H 

#include <stdint.h>
#include "arm_math.h"


class Sine_f32 {
public:
    Sine_f32(uint32_t frequency, uint32_t sample_rate=48000, float32_t amplitude=1.f, float32_t phase=0.0, uint32_t block_size=32);
    
    void process(float32_t *signal);
    
    void reset(void);

private:
    float32_t _dx;
    float32_t _amplitude;
    float32_t _x;
    uint32_t _block_size;
};

#endif
