#include "Sine_f32.h"
#include "math_helper.h"

#define RAD_2PI         (2. * pi)

Sine_f32::Sine_f32(uint32_t frequency, uint32_t sample_rate, float32_t amplitude, float32_t phase, uint32_t block_size) {
    _dx = RAD_2PI * ((float32_t)frequency / (float32_t)sample_rate);
    _amplitude = amplitude;
    _x = phase;
    _block_size = block_size;
}

void Sine_f32::process(float32_t *signal) {
    for (int i=0; i<_block_size; i++) {
        (*signal++) += (_amplitude * arm_sin_f32(_x));
        _x += _dx;
    }
}

void Sine_f32::reset(void) {
    _x = 0.0f;
}
