#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);

void sd_thread(void const *argument) {
    SDFileSystem sd(p5, p6, p7, p8, "sd");
    FILE *f = fopen("/sd/out.txt", "w");
    for (int i=0; i<30; i++) {
        fprintf(f, "%d\n", i);
        printf("%d\n\r", i);
    }
    printf("closing\n");
    fclose(f);
    
    while (true) {
        led2 = !led2;
        Thread::wait(1000);
    }
}

int main() {
    Thread t(sd_thread, NULL, osPriorityNormal, (DEFAULT_STACK_SIZE * 2.25));
    
    while (true) {
        led1 = !led1;
        Thread::wait(1000);
    }
}
