/*
 * Echo server
 * Listens on TCP and UDP ports 7 for any incoming connections
 * Re-transmits any incoming bytes
 */

#include "mbed.h"
#include "EthernetNetIf.h"

#include "EchoServer.h"

// Our Echo server
EchoServer server;

/*
    Function: main
    
    Sets up the Ethernet interface using DHCP, reports the assigned
    IP address via serial, binds the Echo server to port 7 on
    TCP and UDP and then sits in a loop calling Net::poll() to
    keep the network stack doing its thing
*/
int main() {
    printf("\r\nSetting up...\r\n");
    //use DHCP
    
    // Our Ethernet interface
    EthernetNetIf eth;
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    IpAddr ip = eth.getIp();
    
    printf("mbed IP Address is %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]);

    server.bind(7,7);

    printf("Entering while loop Net::poll()ing\r\n");
    while (1) {
        Net::poll();
    }
}
