/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "Servo.h"
#include "color.h"
#include <string>
#include <MQTTClientMbedOs.h>
#include <algorithm>

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

// varijable za boju

float r1[3]={1 ,109.0/399.0,133.0/399.0};
float g1[3]={206.0/411.0,399.0/411.0,1};
float b1[3]={120.0/490.0 ,209.0/490.0, 1};
DigitalOut colorLed(D4);
DigitalOut colorVout(D5);
int salji_boju=0;
int fleg_start=0;
Serial pc(USBTX,USBRX);
// varijable za servo
Servo servo0(D3);
Servo servo1(D6);
DigitalOut Servo1Napajanje(D7);

InterruptIn button(USER_BUTTON);
int arrivedcount = 0;
TCPSocket socket;
MQTTClient client(&socket);
MQTT::Message message;
int button_pressed=0;

//Timeout T1;
//void interruptT1(){
  //  printf("error1");
   // }

char* topic_pub = "PMK_industrija/micro1/color1";
char* topic_pub1 = "PMK_industrija/micro1/echo/2";
char* topic_sub = "PMK_industrija/micro2/#";


WiFiInterface *wifi;
volatile int mems_event = 0;
uint32_t previous_tick = 0;
uint32_t current_tick = 0;
uint8_t high = 0, low = 0;
float temperature = 0.0f;
char buffer[32];

static char *print_double(char *str, double v, int decimalDigits = 2)
{
    int i = 1;
    int intPart, fractPart;
    int len;
    char *ptr;
 
    /* prepare decimal digits multiplicator */
    for (; decimalDigits != 0; i *= 10, decimalDigits--);
 
    /* calculate integer & fractinal parts */
    intPart = (int)v;
    fractPart = (int)((v - (double)(int)v) * i);
 
    /* fill in integer part */
    sprintf(str, "%i.", intPart);
 
    /* prepare fill in of fractional part */
    len = strlen(str);
    ptr = &str[len];
 
    /* fill in leading fractional zeros */
    for (i /= 10; i > 1; i /= 10, ptr++) {
        if (fractPart >= i) {
            break;
        }
        *ptr = '0';
    }
 
    /* fill in (rest of) fractional part */
    sprintf(ptr, "%i", fractPart);
 
    return str;
}

const char *sec2str(nsapi_security_t sec)
{
    switch (sec) {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

int scan_demo(WiFiInterface *wifi)
{
    WiFiAccessPoint *ap;
    printf("Scan:\n");
    int count = wifi->scan(NULL,0);
    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    /* Limit number of network arbitrary to 15 */
    count = count < 15 ? count : 15;
    ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);
    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    for (int i = 0; i < count; i++) {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
    }
    printf("%d networks available.\n", count);
    delete[] ap;
    return count;
}

void messageArrived(MQTT::MessageData& md)
{  char buf[100];
    MQTTString &topic = md.topicName;
    string topic_name = topic.lenstring.data;
    printf("Topic name %d : %s\r\n",topic.lenstring.len,topic_name.c_str() );
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\r\n", message.payloadlen, (char*)message.payload);
    string poruka = (char*)message.payload;
    
    //if(topic_name.find("servo0")!=std::string::npos) {
      //   printf("AKTIVIRAN SERVO0\n"); 
        // for(float p=0; p<1.0; p += 0.1) {
       // servo0 = p;
        
       // }
       // wait(2);
       // for(float p=1.0; p>0.0; p -= 0.1) {
       // servo0 = p;
        
        //}
        
        //sprintf(buf, "servo0-AKTIVIRAN \r\n");
          //  message.qos = MQTT::QOS0;
            //message.retained = false;
            //message.dup = false;
            //message.payload = (void*)buf;
            //message.payloadlen = strlen(buf)+1;
            //client.publish(topic_pub1, message); 
    //}
    //else if(topic_name.find("color1")!=std::string::npos){
    //salji_boju=1;
    //}
    //else if(topic_name.find("servo1")!=std::string::npos){
     //   T1.detach();
      //  printf("AKTIVIRAN SERVO1\n"); 
        // for(float p=0; p<1.0; p += 0.1) {
        //servo1 = p;
      // da li na 45        
        //}
        //wait(2);
        //for(float p=1.0; p>0.0; p -= 0.1) {
        //servo1 = p;
        
        //}  
        
          //  sprintf(buf, "servo1-AKTIVIRAN \r\n");
            //message.qos = MQTT::QOS0;
            //message.retained = false;
            //message.dup = false;
            //message.payload = (void*)buf;
            //message.payloadlen = strlen(buf)+1;
            //client.publish(topic_pub1, message); 

        
        //}
        //else 
        if(topic_name.find("echo")!=std::string::npos){
            if(poruka.find("connect")!=std::string::npos){
            fleg_start=1;
            sprintf(buf, "echo2 \r\n");
            message.qos = MQTT::QOS0;
            message.retained = false;
            message.dup = false;
            message.payload = (void*)buf;
            message.payloadlen = strlen(buf)+1;
            client.publish(topic_pub1, message); 
            }
            else if(poruka.find("echo")!=std::string::npos){
       //         T1.detach();
            }
            }
    ++arrivedcount;

}


void buttonFunction() {    
    button_pressed=1;   
}

int main()
{   
    // Initialise the digital pin LED1 as an output
    colorLed=1;
    colorVout=1;
    
    ColorSensor cs(PA_5,PA_6,PA_7,PB_6,PC_7);
    DigitalOut led(LED1);
    Servo1Napajanje=1;
    servo0.calibrate(0.0005,90);
    servo1.calibrate(0.0005,180);
    button.rise(&buttonFunction);
    
    const char* hostname = "broker.mqttdashboard.com";
    int port = 1883;    
    wifi = WiFiInterface::get_default_instance();
    if (!wifi) {
        printf("ERROR: No WiFiInterface found.\n");
        return -1;
    }

    int count = scan_demo(wifi);
    if (count == 0) {
        printf("No WIFI APs found - can't continue further.\n");
        return -1;
    }

    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\nConnection error: %d\n", ret);
        return -1;
    }

    printf("Success\n\n");
    printf("MAC: %s\n", wifi->get_mac_address());
    printf("IP: %s\n", wifi->get_ip_address());
    printf("Netmask: %s\n", wifi->get_netmask());
    printf("Gateway: %s\n", wifi->get_gateway());
    printf("RSSI: %d\n\n", wifi->get_rssi());

    socket.open(wifi);
    socket.connect(hostname, port);
    
    int rc=0;
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "PMK-client2";
    //data.username.cstring = "testuser";
    //data.password.cstring = "testpassword";
    
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);

    
    if ((rc = client.subscribe(topic_sub, MQTT::QOS2, messageArrived)) != 0)
        printf("rc from MQTT subscribe is %d\r\n", rc);    
    
    
     char buf[100];
            float treshold=0.1;  
    while (true) {
        client.yield(1000);
        if (fleg_start==1){
        led = !led;
        thread_sleep_for(BLINKING_RATE_MS);
        if (salji_boju==1) {
            salji_boju=0;    
            printf("Publishing data\r\n");    
            // QoS 0
           
            
            int Boja[3]={cs.getRed(), cs.getGreen(),cs.getBlue()};
            
            while(Boja[0]<30 && Boja[1]<30 && Boja[2]<30){
                wait(1);
                Boja[0]=cs.getRed();
                Boja[1]=cs.getGreen();
                Boja[2]=cs.getBlue();
                printf("LOSE MERENJE \r\n");
                printf("R:%d , G:%d , B:%d",Boja[0],Boja[1],Boja[2]);
                }
            int strongCol=max(Boja[0],max(Boja[1],Boja[2]));
            float BojaScal[3];
            BojaScal[0]=Boja[0]/(strongCol*1.0);
            BojaScal[1]=Boja[1]/(strongCol*1.0);
            BojaScal[2]=Boja[2]/(strongCol*1.0);        
            
            if(BojaScal[1]<r1[1]+treshold && BojaScal[1]>r1[1]-treshold && BojaScal[2]<r1[2]+treshold && BojaScal[0]>r1[0]-treshold && BojaScal[0]<r1[0]+treshold && BojaScal[2]>r1[2]-treshold ) {
                sprintf(buf, "Jeste \r\n");}
            else if(BojaScal[1]<g1[1]+treshold && BojaScal[1]>g1[1]-treshold && BojaScal[2]<g1[2]+treshold && BojaScal[0]>g1[0]-treshold && BojaScal[0]<g1[0]+treshold && BojaScal[2]>g1[2]-treshold ) {
                sprintf(buf, "Nije \r\n");}
                else if(BojaScal[1]<b1[1]+treshold && BojaScal[1]>b1[1]-treshold && BojaScal[2]<b1[2]+treshold && BojaScal[0]>b1[0]-treshold && BojaScal[0]<b1[0]+treshold && BojaScal[2]>b1[2]-treshold ) {
                sprintf(buf, "Nije \r\n");}
                else { sprintf(buf, "Nije \r\n");}
            
            printf("R: %.3f", BojaScal[0]);
            printf("G: %.3f", BojaScal[1]);
            printf("B: %.3f\r\n", BojaScal[2]);
            
            printf(" Crvena R: %.3f", r1[0]);
            printf("G: %.3f", r1[1]);
            printf("B: %.3f\r\n", r1[2]);
            
            //sprintf(buf, "RGB: %7s C\r\n", print_double(buffer, cs.getRed()*100000000+cs.getGreen()*10000+cs.getBlue()));
            
            message.qos = MQTT::QOS0;
            message.retained = false;
            message.dup = false;
            message.payload = (void*)buf;
            message.payloadlen = strlen(buf)+1;
            client.publish(topic_pub, message);
         //   T1.attach(&interruptT1,5);
        }
        //printf("Yielding"); 
        client.yield(1000);
        //printf(" -> Yielded\r\n"); 
    }
    }
    
}
