#include "DataTypes.h"

#ifndef FIXEDMATH_H_
#define FIXEDMATH_H_


typedef SIGNED_WORD FIXED_7_8;
typedef SIGNED_WORD FIXED_9_6;

typedef SIGNED_WORD FIXED_0_15;
typedef SIGNED_WORD FIXED_1_14;


extern const FIXED_1_14 Fixed_1_14_SineTable [256];
extern const FIXED_7_8 Fixed_7_8_SineTable [256];

#define FMul_15_0(A,B)             (FIXED_0_15)(((FIXED_0_15)(A) * (FIXED_0_15 )(B))>>15)
#define FMul_7_8to0_15(A,B)        (FIXED_7_8)(((FIXED_7_8)(A) * (FIXED_0_15)(B))>>15)
#define FMul_15_0to7_8(A,B)        (SIGNED_WORD)(((SIGNED_WORD)(A) * (FIXED_7_8)(B))>>8)



#define INT_7_8(A)                (SIGNED_WORD)(A>>8)
#define INT_TO_7_8(A)            ((FIXED_7_8)(A)<<8)
#define FRAC_7_8(A)                (FIXED_7_8)(A&0xFF)

#define INT_9_6(A)                (SIGNED_WORD)(A>>6)
#define INT_TO_9_6(A)            ((FIXED_9_6)(A)<<6)
#define FRAC_6_9(A)                (FIXED_9_6)(A&0x3F)



//#define FMul_15_0to0_15            (SIGNED_WORD)(((SIGNED_WORD)(A) * (FIXED_0_15)(B))>>16)
inline SIGNED_WORD FMul_15_0to0_15(SIGNED_WORD A,SIGNED_WORD B)
{
    return  (((long)(A) * (long)(B))>>15);
}

inline SIGNED_WORD FMul_15_0to1_14(SIGNED_WORD A,SIGNED_WORD B)
{
    long temp;
    temp = (((long)(A) * (long)(B))>>13);
    if(temp&0x01)
    {
        temp = temp>>1;
        temp = temp +1;
    }
    else
    {
        temp = temp>>1;
    }
    return  temp;
}

//inline SIGNED_WORD ABS(A)
//{
    //if(A<0)
        //return -A;
    //else
        //return A;    
//}

#endif /*FIXEDMATH_H_*/
