#include "DataTypes.h"

#ifndef _CONFIGURATION_H_
#define _CONFIGURATION_H_

void LoadDefaults();
void LoadConfiguration();
BOOL KeyValueSplit(const CHAR *LineBuf,CHAR Key,CHAR *Value);
void ToLowerCase(CHAR *LineBuf);
void ExportConfigurationSettings();

//Voltage Divider for the Li_poly Battery
extern float R17,R15;

//Voltage Divider for input voltage measurement
extern float R2,R4;

//Voltage Divider for current voltage measurement (to the 16-bit ADC)
extern float R6,R7;

//Voltage Divider for current voltage measurement (to the 12-bit ADC)
extern float R8,R9;

//value of the 2.5Voltage reference
extern float U1_VREF;
//value of the MBED Voltage reference
extern float MBED_VREF;

//Input diode drops
extern float INPUT_DIODE_DROP;


//Parameters for the ACS576 Current Sensor
extern float ACS576_VOFFSET;
extern float ACS576_ISCALE; 
extern float ACS576_IOFFSET_TRIM; 
extern float ACS576_ISCALE_ADJUST; 

//for self current measurement
extern float R18;
extern float R19;
extern float R20;
extern float R22;

extern  float   SAMPLE_RATE;
extern  DWORD   WRITE_BLOCK_THRESH;

#define SAMPLE_RATE_DEFAULT                  (250.0)
#define WRITE_BLOCK_THRESH_DEFAULT           (128)

#define MAX_ID_LENGTH   8
extern CHAR ID[MAX_ID_LENGTH+1];

//Used to correct the input voltage measurement
extern float  VSCALE_ADJUST; 
extern float  VOFFSET_ADJUST; 

#endif
