#include <stdio.h>
#include <stdarg.h>
#include "ff.h"

#define INLINE_BITPLANE_PUT
#define INLINE_BITPLANE_GET

#ifndef DATATYPES_H_
#define DATATYPES_H_

//#define BYTE unsigned char
#define WORD unsigned short
#define DWORD unsigned long

#define SIGNED_BYTE signed char
#define SIGNED_WORD signed short
#define SIGNED_DWORD signed int

//#define CHAR char

#define BOOL BYTE

#ifndef TRUE
#define TRUE 1
#endif  


#ifndef FALSE
#define FALSE 0
#endif  

#ifndef YEP
#define YEP TRUE
#endif  


#ifndef NOPE
#define NOPE FALSE
#endif  


#define STACK_FULL       -1
#define STACK_EMPTY      -2
#define STACK_PUSH_OK     0

#define QUEUE_FULL       -1
#define QUEUE_EMPTY      -2
#define QUEUE_OK          0


typedef struct{

            BYTE *StackSpace;
            WORD Ptr;
            WORD Size;
}    ByteStack;

typedef struct{
            BYTE *StackSpace;
            BYTE Ptr;
            BYTE Size;
} BitStack;

typedef struct {
                
         BYTE *BitPlaneSpace;

        WORD SizeX; // must be a BYTE aligned
        WORD SizeY;
        
} BitPlane;


typedef struct {
    
    WORD ReadPtr;
    WORD WritePtr;
    WORD QueueSize;
    BYTE *QueueStorage;
    
} ByteQueue;



#ifdef INLINE_BITPLANE_PUT
    inline void BitPlane_Put(BitPlane  * BP, WORD X,WORD Y, BOOL Value)
    {
        WORD Offset;
        BYTE Mask;
        
        Offset = (Y * ((BP->SizeX)>>3)) + (X>>3);
        Mask = 0x01 << (X & 0x07);
    
        if(Value)
        {
            BP->BitPlaneSpace[Offset] |= Mask;
        }
        else
        {
            BP->BitPlaneSpace[Offset] &= ~Mask;
        }
    }
#else
    void BitPlane_Put(BitPlane  * BP, WORD X,WORD Y, BOOL Value);
#endif

#ifdef INLINE_BITPLANE_GET
    inline BOOL BitPlane_Get(BitPlane  * BP, WORD X,WORD Y)
    {
        WORD Offset;
        BYTE Mask;
     
        Offset = (Y * ((BP->SizeX)>>3)) + (X>>3);
        Mask = 0x01 << (X & 0x07);
    
        if((BP->BitPlaneSpace[Offset])&Mask)
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }
#else
    BOOL BitPlane_Get(BitPlane  * BP, WORD X,WORD Y);
#endif


void BitPlane_Clear(BitPlane  * BP);

void InitByteQueue(ByteQueue *BQ,WORD Size,BYTE * Storage);
WORD BytesInQueue(ByteQueue *BQ);
SIGNED_WORD ByteDequeue(ByteQueue *BQ,BYTE *Val);
SIGNED_WORD ByteEnqueue(ByteQueue *BQ,BYTE Val);
SIGNED_WORD ByteArrayEnqueue(ByteQueue *BQ,BYTE *Buf,WORD Len);
SIGNED_WORD PrintfEnqueue(ByteQueue *BQ, const char *FormatString,...);

#endif /*DATATYPES_H_*/