#ifndef _SYSTEM_H
#define _SYSTEM_H


#include "DataTypes.h"
#include "mbed.h"
#include "Serial.h"
#include "ADC.h"
#include "Configuration.h"
#include "stdio.h"
#include "FixedMath.h"
#include "KeyValue.h"
#include "SmartSwitch.h"
#include "GFX.h"
#include "ff.h"
#include "FIRMWARE_VERSION.h"
#include "Terminal.h"

#define SYSTEM_STATE_INIT       0   
#define SYSTEM_STATE_LOGGING    1    
#define SYSTEM_STATE_IDLE       2

void EnterSystemState(BYTE NextState);
void InitButton();
void InitRobotPowerMeasurementSystem();

void CheckButton();
void UpdateDisplay();
void CheckSDCardStatus();
void UpdateHostTerminal();

extern BYTE SystemState;

#define DATA_BLOCK_SIZE    1024

typedef struct {

    float   Voltage[DATA_BLOCK_SIZE];
    float   Current[DATA_BLOCK_SIZE];

   SIGNED_DWORD  WriteOutPtr;
   SIGNED_DWORD   ReadInPtr;
     
}DataBlock;

extern DataBlock MyDataBlock;
extern SIGNED_DWORD ReadWriteDifferential;

#define MIN_WRITE_BLOCK_THRESH                (16)
#define MAX_WRITE_BLOCK_THRESH                ((DATA_BLOCK_SIZE/2)-1)

void InitDataBlocks(DataBlock * DB);
extern BOOL DataLogError;
extern CHAR *ErrorMsg;
void LogData();
void DisplayBootMsg();

#endif