#include "System.h"

#ifndef SMART_SWITCH_H
#define SMART_SWITCH_H

extern DigitalOut EnableSmartSwitchPower;
extern DigitalOut SmartSwitch_SS;
extern DigitalOut SmartSwitch_SCK;
extern DigitalOut SmartSwitch_SDI;

#define SMART_SWITCH_CMD_DISPLAY_DATA           0x55
#define SMART_SWITCH_CMD_SET_BACKLIGHT_COLOR    0x40
#define SMART_SWITCH_CMD_SET_BRIGHTNESS         0x41
#define SMART_SWITCH_CMD_RESET                  0x5E
#define SMART_SWITCH_CMD_RESET_PARAMETER        0x03

#define SMART_SWITCH_BACKLIGHT_RED          (0x03<<4)
#define SMART_SWITCH_BACKLIGHT_YELLOW       (0x03<<4)|(0x03<<2)
#define SMART_SWITCH_BACKLIGHT_GREEN        (0x03<<2)



void SmartSwitch_Reset();
void SmartSwitch_SetBackLightColor(BYTE Red,BYTE Green,BYTE Blue);
void SmartSwitch_SetBrightnss(BYTE Brightness);
void InitSmartSwitch();
void PowerUpSmartSwitch();
void PowerDownSmartSwitch();
void SmartSwitchWriteByte(BYTE DataOut);
void SmartSwitch_SetBackLightColor2(BYTE RGB);
void SmartSwitch_ImageDump(BYTE *Img);
void SmartSwitchClear();

#endif

