#include "System.h"

volatile float BatteryVoltage = 0;
volatile float RobotBusVoltageHR = 0;
volatile float RobotBusCurrentHR = 0;

float HighResRobotBusVoltageScalingFactor;
float HighResRobotBusVoltageOffset;
float HighResRobotBusCurrentScalingFactor;

SIGNED_DWORD    ExtADCRobotVoltage=0;
SIGNED_DWORD    ExtADCRobotCurrent=0;

AnalogIn BatteryChannel(p17);
AnalogIn RobotBusCurrentChannel(p20);
AnalogIn RobotBusVoltageChannel(p19);
AnalogIn SelfCurrentChannel(p18);

Ticker  BatteryCheck;
Ticker  InputPowerCheck;

SPI ADCSPI(p11, p12, p13); 
DigitalOut ConversionStart(p14);

void CheckBattery();
void CheckInputPower();

SIGNED_DWORD VFilter[64];
SIGNED_DWORD IFilter[64];
WORD FilterIndex;

SIGNED_DWORD VBattFilter[8];
WORD VBattFilterIndex;

DigitalOut PING(LED3);
DigitalOut PONG(LED4);

volatile BOOL ADCDataRdy;
                           


void InitADC()
{
    HighResRobotBusVoltageScalingFactor = U1_VREF * ((R2 + R4)/(R4)) * VSCALE_ADJUST;
    HighResRobotBusVoltageOffset = INPUT_DIODE_DROP*2;
    HighResRobotBusCurrentScalingFactor = U1_VREF * ((R6+R7)/R7) ;
    
    ACS576_ISCALE = ACS576_ISCALE * ACS576_ISCALE_ADJUST; 
          
    ADCSPI.format(16,0);
       
    ConversionStart = 0;
        
    BatteryCheck.attach(&CheckBattery,0.1);
    InputPowerCheck.attach(&CheckInputPower,(1.0/(SAMPLE_RATE*16)));
 }

void CheckBattery()
{
    int i;
    SIGNED_DWORD TempSum = 0;
    float temp;

    temp =     RobotBusCurrentChannel;
    temp +=    RobotBusVoltageChannel;

    VBattFilter[VBattFilterIndex++] = BatteryChannel.read_u16(); 
    VBattFilterIndex &= 0x7;
    
    for(i=0;i<8;i++)
    {
        TempSum += VBattFilter[i];
    } 
    
    BatteryVoltage = (float)((TempSum>>3))/65535.0f *  MBED_VREF;
}

void CheckInputPower()
{
    SIGNED_DWORD TempSumV,TempSumI;
    int i;
  
    ConversionStart = 1;
    VFilter[FilterIndex] = (SIGNED_WORD)(ADCSPI.write(0x0000));
    IFilter[FilterIndex] = (SIGNED_WORD)(ADCSPI.write(0x0000));
    FilterIndex++;
    ConversionStart = 0; 
    
    //oversample and average   
   if(FilterIndex ==16)
   {
       ADCDataRdy = TRUE;
        FilterIndex = 0;
        TempSumV=0;
        TempSumI=0;
        for(i=0;i<16;i++)
        {
            TempSumV+=VFilter[i];
            TempSumI+=IFilter[i];
         }
       
        ExtADCRobotCurrent = TempSumV>>4;
        ExtADCRobotVoltage = TempSumI>>4;
    
        RobotBusVoltageHR = ((((float)(ExtADCRobotVoltage)/(32768.0f)) * HighResRobotBusVoltageScalingFactor + HighResRobotBusVoltageOffset))- VOFFSET_ADJUST;
        RobotBusCurrentHR = (((((float)(ExtADCRobotCurrent)/(32768.0f)) * HighResRobotBusCurrentScalingFactor) -ACS576_VOFFSET) * ACS576_ISCALE) - ACS576_IOFFSET_TRIM; 
        
        if(SystemState == SYSTEM_STATE_LOGGING)
        {
           
             if (MyDataBlock.WriteOutPtr >MyDataBlock.ReadInPtr)
             {
                  ReadWriteDifferential = (DATA_BLOCK_SIZE - MyDataBlock.WriteOutPtr +  MyDataBlock.ReadInPtr);
             }
             else
             {
                  ReadWriteDifferential = ( MyDataBlock.ReadInPtr - MyDataBlock.WriteOutPtr);
             }
    
             if(ReadWriteDifferential >= DATA_BLOCK_SIZE - 1)
             {
                DataLogError = TRUE;
                ErrorMsg = "Overrun!";
             }
             else
             {
                 MyDataBlock.Voltage[MyDataBlock.ReadInPtr] =  RobotBusVoltageHR;
                 MyDataBlock.Current[MyDataBlock.ReadInPtr] =  RobotBusCurrentHR;
                        
                 MyDataBlock.ReadInPtr++;
                 
                 if(MyDataBlock.ReadInPtr == DATA_BLOCK_SIZE)
                 {
                    MyDataBlock.ReadInPtr = 0;
                 }
             }
         }
         else
         {
              ReadWriteDifferential = 0;
         }
     }
}



