#include "System.h"

DigitalOut EnableSmartSwitchPower(p27);
DigitalOut SmartSwitch_SS(p24);
DigitalOut SmartSwitch_SCK(p25);
DigitalOut SmartSwitch_SDI(p26);

void SmartSwitch_ImageDump(BYTE *Img)
{
   int i;
   
   SmartSwitch_SS = 0;
   SmartSwitchWriteByte(SMART_SWITCH_CMD_DISPLAY_DATA);
   
   for(i=0;i<256;i++)
   {
    SmartSwitchWriteByte(Img[i]);
   }
   
   SmartSwitch_SS = 1;
}

void SmartSwitchClear()
{
   int i;
   
   SmartSwitch_SS = 0;
   SmartSwitchWriteByte(SMART_SWITCH_CMD_DISPLAY_DATA);
   
   for(i=0;i<256;i++)
   {
    SmartSwitchWriteByte(0x00);
   }
   
   SmartSwitch_SS = 1;
}

void SmartSwitch_Reset()
{
   SmartSwitch_SS = 0;
   SmartSwitchWriteByte(SMART_SWITCH_CMD_RESET);
   SmartSwitchWriteByte(SMART_SWITCH_CMD_RESET_PARAMETER);
   SmartSwitch_SS = 1;
}

void SmartSwitch_SetBackLightColor(BYTE Red,BYTE Green,BYTE Blue)
{
   SmartSwitch_SS = 0;
   SmartSwitchWriteByte(SMART_SWITCH_CMD_SET_BACKLIGHT_COLOR);
   SmartSwitchWriteByte(Red<<6 | Green<<4 | Blue <<2 | 0x3);
   SmartSwitch_SS = 1;
}

void SmartSwitch_SetBackLightColor2(BYTE RGB)
{
   SmartSwitch_SS = 0;
   SmartSwitchWriteByte(SMART_SWITCH_CMD_SET_BACKLIGHT_COLOR);
   SmartSwitchWriteByte(RGB<<2 | 0x3);
   SmartSwitch_SS = 1;
}

void SmartSwitch_SetBrightnss(BYTE Brightness)
{
   SmartSwitch_SS = 0;
   SmartSwitchWriteByte(SMART_SWITCH_CMD_SET_BRIGHTNESS);
   SmartSwitchWriteByte(Brightness<<5 | 0x1F);
   SmartSwitch_SS = 1;
}



void InitSmartSwitch()
{
   SmartSwitch_SS = 1;
   SmartSwitch_SCK = 1;
   SmartSwitch_SDI = 1;
   PowerUpSmartSwitch();
   SmartSwitch_Reset();
   
}

void PowerUpSmartSwitch()
{
    EnableSmartSwitchPower = 1;
}

void PowerDownSmartSwitch()
{
    EnableSmartSwitchPower = 0;
    SmartSwitch_Reset();
    SmartSwitch_SetBackLightColor(0,0,0);
}

void SmartSwitchWriteByte(BYTE DataOut)
{
    BYTE i;
    
    SmartSwitch_SCK = 1;
    
    for(i=0;i<8;i++)
    {
        if(DataOut & (0x01<<(7-i)))
        {
            SmartSwitch_SDI = 1;
        }
        else
        {
            SmartSwitch_SDI = 0;
        }
   
     SmartSwitch_SCK = 0;
     SmartSwitch_SCK = 1;
    }
}


