#include "System.h"

char StringBuffer[256];

#define TEMPERATURE_FILTER_SIZE     16

float TemperatureFilterBuffer[TEMPERATURE_FILTER_SIZE] = {0};

uint32_t TemperatureFilterIndex = 0;

float Temperature = 0;

Ticker SystemTicker;

volatile uint32_t SensorUpdateTicker = 0;

//This is used for some general purpose timing in the main loop
void SystemTick()
{
    if(SensorUpdateTicker < 0xFFFFFFFF)
        SensorUpdateTicker++;
}

int main()
{
    uint32_t i;
    
    DISABLE_HIGH_CURRENT_RELAY;
    DISABLE_LOW_CURRENT_RELAY;
    
    InitTerminal(); //Initialize the Terminal State machine

    //Setup ouur ticker for 1mS
    SystemTicker.attach_us(SystemTick,1000);

    PC.printf("\r\n\r\nMonkey Do!\r\n");


    PC.printf("Ethernet Init!\r\n");
    eth.init(); //Use DHCP
    eth.connect();
    PC.printf("IP Address is %s\r\n", eth.getIPAddress());

    Websocket ws("ws://sockets.mbed.org:443/ws/emh203/rw");

    ws.connect();

    while (1) {

        //Send sensor data to the websocket every second
        if(SensorUpdateTicker >= 1000) 
        {
            SensorUpdateTicker = 0;

            Temperature = 0;
            
            //Take a bunch of measurements and average to help with Data converter Noise
            
            for(i=0;i<TEMPERATURE_FILTER_SIZE;i++)
            {
            Temperature += ((TempSensor.read() * 3.3f)// * //convert to volts
                                - 0.500f) // subtract off 0c offset   ....  you may need to calibrate... see MCP9700A-E/TO data sheet
                                  * 100.0f; // Scale to Degrees C
            }
            Temperature = Temperature / TEMPERATURE_FILTER_SIZE;

            sprintf(StringBuffer,"temp %.1f\r\n",Temperature);
            ws.send(StringBuffer);
        }

        //See if we have an incoming command, if so process it
        if(ws.read(StringBuffer) == true) 
        {
            //our command structure is a simple ascii string.
            //
            //Cmd arg1 arg2 .....
            //
            //The command is the 1st string.    Each argument is separated by white space
            //
            //for example:
            //
            //ssr 1 0
            //
            //is the "ssr" command with 2 arguments: 1 and 0
            //
            //
            //There are many ways to process a command but I will use my "Terminal" processor
            //It normally is used to emulated a basic command line terminal from a serial port but it
            //can easily process ourwebsocket data.
            //
            //

           

            //see if this is the command we sent out.  The Mbed Websocket server sends input messagest
            //to all who are attached.  This means we get our own messages back.   
            
            if(strncmp(StringBuffer,"temp",4) == 0)
            {
                //this means we go the temp message back, do nothing    
            }
            else
            {
                 //The first thing to do is copy the data into the terminal input queue
                  ByteArrayEnqueue(&TERMINAL_INPUT_QUEUE,(uint8_t *)StringBuffer,strlen(StringBuffer));
                  //We also need a put in a new line character so the terminal will think a new command has been entered
                   ByteEnqueue(&TERMINAL_INPUT_QUEUE,'\r');
            }

            //Now that the data is in the terminal input queue,   the ProcessTerminal() function will do the rest
        }

        //This will process any incoming data to the terminal
        ProcessTerminal();

        //In addition to the websocket interface,   we will also have a simple virtual command line terminal over the USB virtual com port.
        //As of 2014-06-24 the Serial IRQ routines are not function in the mbed libraries for the FRDM-K64.   For the mean time
        //We will just manually shuffle data in and out of the terminal queues.    The baud rate is slow enough in that the main loop will have plenty of time to
        //move everything.   Ideally I would want interrupts to keep everything flowing but this will be good enough for now.
  
   
        if(PC.readable()) {
            ByteEnqueue(&TERMINAL_INPUT_QUEUE,PC.getc());
        }
        if(BytesInQueue(&TERMINAL_OUTPUT_QUEUE)>0) {
            if(PC.writeable()) {
                PC.putc(ForcedByteDequeue(&TERMINAL_OUTPUT_QUEUE));
            }
        }

    }



}



