
#include "System.h"
#include "Queue.h"

#ifndef TFC_TERMINAL_H_
#define TFC_TERMINAL_H_


extern ByteQueue TERMINAL_OUTPUT_QUEUE;
extern ByteQueue TERMINAL_INPUT_QUEUE;


void InitTerminal();
void ProcessTerminal();

    #define TERMINAL_PRINTF(...)        Qprintf(&TERMINAL_OUTPUT_QUEUE,__VA_ARGS__)  
    #define TERMINAL_PUTC(c)            ByteEnqueue(&TERMINAL_OUTPUT_QUEUE,c)
    #define TERMINAL_READABLE           BytesInQueue(&TERMINAL_INPUT_QUEUE)
    #define TERMINAL_GETC               ForcedByteDequeue(&TERMINAL_INPUT_QUEUE)


typedef void (*TerminalCallback)(char *);

typedef struct 
{
    const char *CommandString;
    TerminalCallback Callback;
    const char *HelpString;
        
} TerminalCallbackRecord;




#endif /* TFC_TERMINAL_H_ */
