/*

--------------------------------------------
|                                          |
|                     ....                 |
|                    7OO$?I78.             |
|                   .?8++++7+II?D.         |
|                   .?O++=I++II+?=         |
|                   .IO++?7==I??$.         |
|                   .8++=$===?+I$          |
|                   ?+++===+===+           |
|                   ???=+I++==+?           |
|                 .??++====+==++           |
|                 ?+++==========~          |
|                $+++==========+=          |
|              =?+===+==+I========         |
|           ..++======~~~~========?        |
|         .$?I??+=~~===~~~===~===++.       |
|       .+==.+=~~~=~==~~~~==~~=~==+?       |
|      ?===I+====~~=~~~=~~=====~~~=?.      |
|     .=~~~+==~==..~~~~~~=    ~~~~=7=      |
|     +=~~?+~~=.  ==~~~~=.     ~~~~=?.     |
|     =~~~=~~~   ?===~~+.       ~~~~+      |
|     +~~:+~~=    =~~==.        =~~+.      |
|     ~:~ =~~=    =~~~=         ~===       |
|         I=~~   ,=~~=            ,.       |
|          ~~.   ,====                     |
|                 ====                     |
|                 =~~.                     |
|                                          |
|------------------------------------------|                                                          
|              Internet Of Thing           |
|                  Eli Hughes              |
| Freescale / Hack-a-day Make-It-Challenge |
|              FTF 2014 - Dallas, Tx       |
|------------------------------------------|

*/
#include "Queue.h"

#ifndef TFC_TERMINAL_H_
#define TFC_TERMINAL_H_


extern ByteQueue TERMINAL_OUTPUT_QUEUE;
extern ByteQueue TERMINAL_INPUT_QUEUE;


void TFC_InitTerminal();
void TFC_ProcessTerminal();

    #define TERMINAL_PRINTF(...)        Qprintf(&TERMINAL_OUTPUT_QUEUE,__VA_ARGS__)  
    #define TERMINAL_PUTC(c)            ByteEnqueue(&TERMINAL_OUTPUT_QUEUE,c)
    #define TERMINAL_READABLE           BytesInQueue(&TERMINAL_INPUT_QUEUE)
    #define TERMINAL_GETC               ForcedByteDequeue(&TERMINAL_INPUT_QUEUE)


#endif /* TFC_TERMINAL_H_ */
