/*

--------------------------------------------
|                                          |
|                     ....                 |
|                    7OO$?I78.             |
|                   .?8++++7+II?D.         |
|                   .?O++=I++II+?=         |
|                   .IO++?7==I??$.         |
|                   .8++=$===?+I$          |
|                   ?+++===+===+           |
|                   ???=+I++==+?           |
|                 .??++====+==++           |
|                 ?+++==========~          |
|                $+++==========+=          |
|              =?+===+==+I========         |
|           ..++======~~~~========?        |
|         .$?I??+=~~===~~~===~===++.       |
|       .+==.+=~~~=~==~~~~==~~=~==+?       |
|      ?===I+====~~=~~~=~~=====~~~=?.      |
|     .=~~~+==~==..~~~~~~=    ~~~~=7=      |
|     +=~~?+~~=.  ==~~~~=.     ~~~~=?.     |
|     =~~~=~~~   ?===~~+.       ~~~~+      |
|     +~~:+~~=    =~~==.        =~~+.      |
|     ~:~ =~~=    =~~~=         ~===       |
|         I=~~   ,=~~=            ,.       |
|          ~~.   ,====                     |
|                 ====                     |
|                 =~~.                     |
|                                          |
|------------------------------------------|                                                          
|              Internet Of Thing           |
|                  Eli Hughes              |
| Freescale / Hack-a-day Make-It-Challenge |
|              FTF 2014 - Dallas, Tx       |
|------------------------------------------|

*/
#include "mbed.h"
#include "Queue.h"
#include "Terminal.h"
#include "System.h"
 

 //Note --   Seems that there is a bug with the new K64 firmware.    When I enable 2 serial port objects there seems to be some cross mojination going on.   We use a 
 //macro to select wifi or com port for debug
 
#define USE_WIFI

#define DATA_BUFFER_MAX_SIZE    128
 
DigitalOut   SPIN_CCW (PTA2);
DigitalOut   SPIN_CW  (PTC2);
DigitalOut   GO_FORWARD (PTC3);
DigitalOut   GO_REVERSE (PTB23);
 
#ifdef USE_USB
    Serial PC(USBTX, USBRX); // tx, rx
#endif

#ifdef USE_WIFI
    Serial WIFI(PTC17,PTC16);
#endif

uint8_t DataBuffer[DATA_BUFFER_MAX_SIZE];
 
int main (void)
{
    uint32_t i;
    uint8_t DataOut;
    uint32_t BytesToSend;
    
    #ifdef USE_WIFI
       
        WIFI.baud(115200);
    
    #endif
    
    #ifdef USE_USB
    
        PC.baud(115200);
    
    #endif

        
    TFC_InitTerminal();

    while(1)
    {

        //Shuffle Datafrom the terminal Queue to the USB port or TCP Port
        //Inefficient but workable
        BytesToSend = BytesInQueue(&TERMINAL_OUTPUT_QUEUE);
        
        if(BytesToSend >0)
        {
            //Limit to maximum chunk size
            
            if(BytesToSend > DATA_BUFFER_MAX_SIZE)
                BytesToSend = DATA_BUFFER_MAX_SIZE;

            for(i=0 ; i< BytesToSend; i++)
            {
                ByteDequeue(&TERMINAL_OUTPUT_QUEUE,&DataOut);
               
               #ifdef USE_USB
                     PC.putc(DataOut);
               #endif
               
                #ifdef USE_WIFI
                  WIFI.putc(DataOut);
                #endif
             }   
        }
        
        
     
 
        #ifdef USE_USB
        if(PC.readable())
            {
            
               ByteEnqueue(&TERMINAL_INPUT_QUEUE,PC.getc());
            }
        #endif
       
      #ifdef USE_WIFI
            
        if(WIFI.readable())
        {
            DataOut = WIFI.getc();
            ByteEnqueue(&TERMINAL_INPUT_QUEUE,DataOut);
          
         }
        #endif
    
    TFC_ProcessTerminal();
        
    }
  
}


