#include "mbed.h"
#include "CHEM_BOX_INTERFACE.h"

Timer ControlLoopTimer;
float CurrentTemperature;

#define VT100_RED     "\033[31;40m"
#define VT100_GREEN   "\033[32;40m"
#define VT100_YELLOW  "\033[33;40m"
#define VT100_BLUE    "\033[34;40m"
#define VT100_MAGENTA "\033[35;40m"
#define VT100_CYAN    "\033[36;40m"
#define VT100_WHITE   "\033[37;40m"
#define VT100_RESET   "\033c"

extern void WriteRAW_DAC_Value(uint8_t Channel,uint16_t Data);

int main() 
{
    int i;
    char * Color = VT100_WHITE;
    //This function always needs called before you do anythign wit the CHEM BOX.
    InitChemBox();

    GREEN_LED = 1;
    RED_LED = 0;

    //Beep 6 times
    for(i=0;i<6;i++)
      {
        Buzz(.05);  //Since the Buzz function immediately returns we should wait a bit before calling it again in the loop
        wait(.1);   //I want a 50% duty cycle so I will wait twice as long as my previous Buzz() call
   
        GREEN_LED = !GREEN_LED;
        RED_LED = !RED_LED;
   
     }
    
     
    GREEN_LED = 1;
    RED_LED = 0;
     
    //Here is the main super loop
    
    //reset and start our control loop Timer
    ControlLoopTimer.reset();
    ControlLoopTimer.start();

    while(1)
     {
          //Call this often if you want the USB interface/Terminal
          ProcessTerminal();
        
        //Call this process incoming lines from the pump
          ProcessRS232();

  
      /*
          if(ControlLoopTimer.read_ms() >= 1000)
            {
                ControlLoopTimer.reset();   
              
              
                PC.printf(VT100_RESET);
                            
            }*/
      
      
            /*
            
            //control loop example
            //We will do something ever 250mS.
            //Use a timer and an if statement we won't hold the microprocessor from do other things in the main super loop!
            if(ControlLoopTimer.read_ms >= 250)
            {
                ControlLoopTimer.reset();    
                
                //if 250mSec has elapsed then do our control loop
                
                CurrentTemperature = ReadThermocouple(0);
                
                if(CurrentTemperature < 15.5)
                {
                    EnableHeater(0);
                }
                else
                {
                   DisableHeater(0);
                }
                
                FlushDigitalIO(); //Remeber, the digital outs are queued up until this is called!
            }
            */
     }

}
