#include "MODSERIAL.h"

#ifndef CHEM_BOX_INTERFACE
#define CHEM_BOX_INTERFACE

#define API_VERSION "1.1"

//     _____ _    _ ______ __  __   ____   ______   __           _____ _____ 
//    / ____| |  | |  ____|  \/  | |  _ \ / __ \ \ / /     /\   |  __ \_   _|
//   | |    | |__| | |__  | \  / | | |_) | |  | \ V /     /  \  | |__) || |  
//   | |    |  __  |  __| | |\/| | |  _ <| |  | |> <     / /\ \ |  ___/ | |  
//   | |____| |  | | |____| |  | | | |_) | |__| / . \   / ____ \| |    _| |_ 
//    \_____|_|  |_|______|_|  |_| |____/ \____/_/ \_\ /_/    \_\_|   |_____|
//                                                                           
//                                                                           

//Initializes the hardware for the Chem box.   Must be called before any other CHEM box functions are called.
void InitChemBox();

extern DigitalOut RED_LED;

extern DigitalOut GREEN_LED;

//Special Note....   All of the Digital IO functions are queued.  This means that they do not take effect
//until the function FlushDigitalIO() is called.


//Enables one of the 8 heater channels.   Just pass a number between 0 and 7
void EnableHeater(uint8_t RelayIndex);


//Disables one of the 8 heater channels.   Just pass a number between 0 and 7
void DisableHeater(uint8_t RelayIndex);

//Enables one of the 12 Solenoid valve channels.   Just pass a number between 0 and 12
void EnableSolenoidValve(uint8_t SolenoidIndex);

//Disables one of the 12 Solenoid valve channels.   Just pass a number between 0 and 12
void DisableSolenoidValue(uint8_t SolenoidIndex);

//Enables one of the 4 digital I/O channels.   Just pass a number between 0 and 3
void EnableMiscDigitalOutput(uint8_t DigitalOutIndex);

//Disables one of the 4 digital I/O channels.   Just pass a number between 0 and 3
void DisableMiscDigitalOutput(uint8_t DigitalOutIndex);

//Updates all of the Digital I/O, heater and solenoid channels.  Call this function to enable all the queued up I/O commands
void FlushDigitalIO();

//Immediatelly disables all heaters and Solenoids.   FlushDigitalIO() does not need to be called for this to have an effect  
void DisableAllHeatersAndSolenoids();

//Enables the +/-15v power to the MFC Channels
void EnableMFC_Power();

//Disbales the +/-15v power to the MFC Channels
void DisableMFC_Power();

//Writes to one of the MFC Analog output channels.    The Value given to the function is in volts
void WriteMFC_AnalogOut(uint8_t Channel,float Value);

//Reads on the MFC Analog input channels.    The value returned is in volts
float ReadMFC_AnalogInput(uint8_t Channel);

//Reads a 4 to 20mA channel.   value returned is in amps (.004 to .020)
float Read4to20(uint8_t Channel);

//Turns the Fan on
void EnableFan();

//Turns the Fan off();
void DisableFan();

// Makes the buzzer ring for a time period (in seconds)
//Note that this function immediately exits and the beeping is done in the background
//If you want to beep a couple times,  you will need to delay for a certain time period after you call this function
//before you can call it again
void Buzz(float Time);

//reads a thermocouple.  Returns temperature in degrees C
float ReadThermocouple(uint8_t ThermocoupleIndex);

//Determines if a thermocouple is disconnected.  Each BIT in the return will be set if the Thermocouple is open.
//so,  to see if a particular thermocouple is no connected, you need to bitmask the result.
/*
    OC_State = ReadThermocouple_OC();

    if(OC_State & (1<<5))
        {
            //we are here if thermocouple 5 is not connected.   The if statement does a bitwise AND to check the bit    
        }

*/
uint16_t ReadThermocouple_OC();



//Determines if a thermocouple is shorted to ground.  Each BIT in the return will be set if the Thermocouple is sorted to ground.
//so,  to see if a particular thermocouple is shorted to ground, you need to bitmask the result.
/*
    SCG_State = ReadThermocouple_SCG();

    if(SCG_State & (1<<7))
        {
            //we are here if thermocouple 7 is shorted to ground.   The if statement does a bitwise AND to check the bit    
        }

*/
uint16_t ReadThermocouple_SCG();

//Determines if a thermocouple is shorted to VCC.  Each BIT in the return will be set if the Thermocouple is shorted to VCC.
//so,  to see if a particular thermocouple is shorted to VCC, you need to bitmask the result.
/*
    SCV_State = ReadThermocouple_SCG();

    if(SCv_State & (1<<4))
        {
            //we are here if thermocouple 5 is shorted to VCC.   The if statement does a bitwise AND to check the bit    
        }

*/
uint16_t ReadThermocouple_SCV();



//Determines if a thermocouple is faulted (see MAX31855 Datasheet).  Each BIT in the return will be set if the Thermocouple is faulted
//so,  to see if a particular thermocouple is faulted, you need to bitmask the result.
/*
    Faulted_State = ReadThermocouple_FAULT();

    if(Faulted_State  & (1<<10))
        {
            //we are here if thermocouple 10 is faulted   The if statement does a bitwise AND to check the bit    
        }

*/


uint16_t ReadThermocouple_FAULT();

/*
Read the internal reference temperature
*/
float ReadInternalTemperature(uint8_t ThermocoupleIndex);

//Writes to one of the Misc Analog Output channels.  The Value shoul dbe in Volts (from 0 to 5v)
void WriteMISC_AnalogOut(uint8_t Channel,float Value);

//Reads one of the MISC Analog Input channels.   The value returned will be in volts (from 0 to 5v)
float ReadMISC_AnalogInput(uint8_t Channel);

//This function must be called in your main loop if you want the USB terminal interface to work!
void ProcessTerminal();


//This is the Serial object (see MODSERIAL Documentation on the MBED site for details) for RS-232 channel 0
extern MODSERIAL RS232_0;

//This is the Serial object (see MODSERIAL Documentation on the MBED site for details) for RS-232 channel 0
extern MODSERIAL RS232_1;

//This is the serial object for the USB connection.  Used by the Serial terminal
extern MODSERIAL PC;

//Process incomings lines from the PUmp
void ProcessRS232();

#endif