/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: Define events during Join, Tx & Rx
            Prepare TX packet by appending with appropriate application data

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Uttam Bhat
*/

#ifndef __LORA_EVENT_PROC_H__
#define __LORA_EVENT_PROC_H__

#include "board.h"
#include "LoRaApp.h"
#include "LoRaDeviceStateProc.h"

/*!
 * \brief   Prepares the payload of the frame specific to the application port
 *
 * \param [IN] port application port 
 */
void PrepareLoRaFrame( uint8_t port );

/*!
 * \brief   Prepares the payload of the frame based on application port
 */
void InitNextTxInterrupt( uint8_t port );

/*!
 * \brief  Define action during the Network Join process: Blink, Toggle or Set LED ON
 */
void JoinEvent( void );

/*!
 * \brief  Define action during the Transmit process: Blink, Toggle or Set LED ON
 */
void TxEvent( void );

/*!
 * \brief  Define action when downlink received: Blink, Toggle or Set LED ON
 */
void RxEvent( void );

void InitDutyCycleTimer( void );

void InitDelayTimer( void );

#endif // __LORA_EVENT_PROC_H__
