/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: Definition of parameters for Compliance Test

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __COMPLIANCE_H__
#define __COMPLIANCE_H__

#include "mbed.h"
#include "Common.h"
#include "Config.h"
#include "LoRaMac.h"

#define COMPLIANCE_TX_DUTYCYCLE 5000000 // 5sec

struct ComplianceTest_s
{
    bool Running;
    uint8_t State;
    bool IsTxConfirmed;
    uint8_t AppPort;
    uint8_t AppDataSize;
    uint8_t *AppDataBuffer;
    uint16_t DownLinkCounter;
    bool LinkCheck;
    uint8_t DemodMargin;
    uint8_t NbGateways;
};

extern ComplianceTest_s ComplianceTest;

void PrepareComplianceTestFrame( McpsIndication_t *McpsIndication );
void RunComplianceTest( void );

#endif // __COMPLIANCE_H__