#include "mbed.h"
#include "db.h"
#include "SDFileSystem.h"

void db_insert_tuple(char *new_name, char *new_code, char *bitlength, char *format)
{

    char tuple_code[128];
    char tuple_name[128];
    char tuple_id[128];
    char tuple_bitlength[128];
    char tuple_format[128];
    int id = 0;
    string pad = "";
    // create file if it does not exist
    FILE *ftemp = fopen("/sd/SmartRemote/db.txt", "a");
    fclose(ftemp);

    // read file to get last id
    FILE *fdb = fopen("/sd/SmartRemote/db.txt", "r");
    while ( !feof(fdb) ) {
        db_get_tuple(fdb, tuple_id, tuple_name, tuple_code, tuple_bitlength, tuple_format);
        if (strlen(tuple_name) != 0) {
            printf("Tuple: |%s| \t |%s| \t |%s| \t |%s| \t |%s|\n", tuple_id, tuple_name, tuple_code, tuple_bitlength, tuple_format);
            id = atoi(tuple_id);
        }
    }
    fclose(fdb);

    // id of new tuple
    id++;
    sprintf(tuple_id, "%d", id);

    // write new tuple to file
    char new_row[128];
    FILE *fwrite = fopen("/sd/SmartRemote/db.txt", "a");

    if (fwrite == NULL) {                                                   // if error
        printf("Could not open file for write\n");
    }
    
    // create new row
    sprintf(new_row, "%s\n%s\n%s\n%s\n%s\n", tuple_id, new_name, new_code, bitlength, format);

    fprintf(fwrite, new_row);                                               // write to file
    fclose(fwrite);                                                         // close file

    printf("Record Added: %s\n", new_row);
}

void db_print_all(FILE *fread)
{
    char c;
    while ( !feof(fread) ) {
        c=fgetc(fread);
        printf("%c", c);
    }
}

void db_find_tuple(int id_to_find, char *tuple_name, char *tuple_code, char *tuple_bitlength, char *tuple_format)
{
    FILE *fread = fopen("/sd/SmartRemote/db.txt", "r");
    
    char tuple_id[128];
    int id;

    while ( !feof(fread) ) {
        db_get_tuple(fread, tuple_id, tuple_name, tuple_code, tuple_bitlength, tuple_format);
        if (strlen(tuple_name) != 0) {
            id = atoi(tuple_id);
            if (id == id_to_find) {
                break;
            }
        }
        else {
            sprintf(tuple_id, "%d", 0);
            sprintf(tuple_name, "%s", "");
            sprintf(tuple_code, "%s", "");
            sprintf(tuple_bitlength, "%s", "");
            sprintf(tuple_format, "%s", "");
        }
    }

    printf("Tuple Found: |%s| \t |%s| \t |%s| \t |%s| \t |%s|\n", tuple_id, tuple_name, tuple_code, tuple_bitlength, tuple_format);
    
    fclose(fread);
}

void db_get_tuple(FILE *fread, char *id_str, char *name_str, char *code_str, char *bitlength_str, char *format_str)
{

    unsigned char c;
    int index;

    // read ID;
    index = 0;
    do {
        c = fgetc(fread);
        id_str[index] = c;
        index++;
    } while (c != '\n' &&  !feof(fread) );
    id_str[index-1] = 0;

    // read NAME;
    index = 0;
    do {
        c = fgetc(fread);
        name_str[index] = c;
        index++;
    } while (c != '\n' &&  !feof(fread) );
    name_str[index-1] = 0;

    // read CODE
    index = 0;
    do {
        c = fgetc(fread);
        code_str[index] = c;
        index++;
    } while (c != '\n' &&  !feof(fread) );
    code_str[index-1] = 0;

    // read BITLENGTH
    index = 0;
    do {
        c = fgetc(fread);
        bitlength_str[index] = c;
        index++;
    } while (c != '\n' &&  !feof(fread) );
    bitlength_str[index-1] = 0;

    // read FORMAT
    index = 0;
    do {
        c = fgetc(fread);
        format_str[index] = c;
        index++;
    } while (c != '\n' &&  !feof(fread) );
    format_str[index-1] = 0;
}