#include "mbed.h"

/*
 By www.emcu.eu
 Date December 2018
 Simple test for RC motor
 Version 1.0
 Tested on the NUCLEO-F411RE and MG996R RC motor
 
 For make this example you must use a NUCLEO board (we tested this example on
    NUCLEO-F411RE) and connect it the components below:
 A potentiometer - Connect it to 3,3v and GND and the central pin of the 
    potentiometer must connect to A5 (PA_10).
 A RC motor - Connect the BLACK wire to GND, RED wire to 5v and 
    ORANGE wire to D2 (PC_0).

 For more info see here:
 http://www.emcu.eu/test-board-for-rc-motors
 
 For use this example turn the potentiometer all to right and you must see the motor that move to right and a LED that flash.
 If you move the potentiometer all to left you must see the motor that move left.
 If you move the potentiometer in the middle position the RC motor is in stop and the LED flash fast.
 If the potentiometer is in the middle and you press Blue button you start an automatic sequence.
 
 For see the message from the SW open TeraTerm (terminal emulation) and configure it to: 8N1
 
 Tested on Servo Motor:
 MG996R - http://www.electronicoscaldas.com/datasheet/MG996R_Tower-Pro.pdf
 
 RED    - + Vcc from 4,5 to 7,2V
 BLACK  - GND
 ORANGE - PWM
 
  Duty - example: 1.9 (mS)
  \  / 
   \/
   __
__|  |_____________
     ... 20mS......
     
 For rotate to right use value 1 for Duty
 For rotate to left use value 5 for Duty
 
*/

AnalogIn adc_chA5(PC_0);
DigitalOut Drive(PA_10);  
DigitalOut led(LED1);
DigitalIn mybutton(USER_BUTTON);

#define Right   1 // Move to Right -> DESTRA   or DX
#define Left    5 // Move to LEFT  <- SINISTRA or SX

void Move(double);
void Seq1(int n);
void Seq2(void);

int main()
{
    float Pot = 0;
    int Movimento = 1;
    
    printf("\n\r STM32 RC motor test ver.1.0\n\r");
    
    Pot=adc_chA5;
    
    while(1) 
    {
        led = !led;
        wait(0.1);
        
        Pot = adc_chA5;
        Pot = Pot * 3300; // Change the value to be in the 0 to 3300 range
        Movimento = Pot/1000;
        printf(" 1 - Val.Pot %.0f mV - Movimento %d \n\r",Pot,Movimento);
        
        if(Pot>=1000 & Pot<=2900)
        {
            printf("\n\r *** RC motor stopped - Press Blue button for automatic sequence ***\n\r");
            led = 0;
            if (mybutton == 0)
                Seq2();
        }
        else
        {
            if (Movimento <= 1)
                Movimento = 1;
            else
                Movimento = 5;
            printf(" 2 - Val.Pot %.0f mV - Movimento %d \n\r",Pot,Movimento);
            Seq1(Movimento);
            wait(1);
        }    
        
        wait(0.2);   
    }
}

void Move(double ON)
{ 
Drive=1;
wait_ms(ON);
Drive=0;
wait_ms(25);
}



void Seq1(int n)
{
    if (n<=1)
    {
        n=5;
        printf("\n\rMove to RIGHT ->\n\r");
    }
    else
    {
        n=1;
        printf("\n\rMove to LEFT  <-\n\r");     
    }
    Move(n);
}

void Seq2(void)
{
    int n=0;
    
    printf("\n\rSequ n.2\n\r");
    led = 1;
    
    printf("Move to 20 times to <-\n\r");
    for(n=0; n<20; n++)
        Move(Left);
    wait(0.3);
    printf("Move to 20 times to ->\n\r");
    for(n=0; n<20; n++)
        Move(Right);    
    wait(0.3);
    
    printf("Move to 8 times to <-\n\r");
    for(n=0; n<8; n++)
        Move(Left);
    wait(0.3);    
    printf("Move to 5 times to ->\n\r");
    for(n=0; n<5; n++)
        Move(Right);
    wait(0.3);     

    printf("Move to 3 times to <-\n\r");
    for(n=0; n<3; n++)
        Move(Left);
    wait(0.3);    
    printf("Move to 3 times to ->\n\r");
    for(n=0; n<3; n++)
        Move(Right);
    wait(0.3);     
    
    printf("Move to 2 times to <-\n\r");
    for(n=0; n<2; n++)
        Move(Left);
    wait(0.3);    
    printf("Move to 2 times to ->\n\r");
    for(n=0; n<2; n++)
        Move(Right);
    wait(0.3);     

    printf("Move to 1 times to <-\n\r");
    for(n=0; n<1; n++)
        Move(Left);
    wait(0.3);    
    printf("Move to 1 times to ->\n\r");
    for(n=0; n<1; n++)
        Move(Right);
    wait(0.3);     
    
    printf("END - Seq n.2\n\r");
    led = 0;
}
