
// By: www.emcu.it
// Tested on NUCLEO_L152RE
// for more info see here: http://www.emcu.it/NUCLEOevaBoards/U2andL152/U2andL152.html#How_to_use_USART2
//
/*
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
//
// This program send a character (E) via USART2 by pressing USER button (Blue Button) on NUCLEO board.
// For test this example are necessary two NUCLEO-L152RE connected as shown below.
//
//    NUCLEO-L152RE n.1       NUCLEO-L152RE n.2
//    TX-D1 ----------------- RX-D0
//    RX-D0 ----------------- TX-D1
//    GND   ----------------- GND
//
// ATTENTION:
// For connect USART2 to D1/TX and D0/RX it is necessary do a bridge on SB63 and SB62 and
// it is also necessary remove the bridge (0 ohm resistor) from SB13 and SB14.
// SB62,62,13 and SB14 are on the rear of NUCLEO_L152RE board 
/*
    After this modifications, you lost the possibility to use the virtual comm to connect 
    the NUCLEO to the PC.

*/


#include "mbed.h"
 
Serial pc(SERIAL_TX, SERIAL_RX);    // tx, rx
DigitalOut myled(LED1);             // This LED is on NUCLEO-L152RE
DigitalIn BlueButton(USER_BUTTON);  // This is Blue-Button and is on NUCLEO-L153RE

#define Pressed 0
#define NotPressed 1

int Car='\0';

int main() {
    while(1) 
    {

    if (BlueButton == Pressed)
        pc.putc('E');
    
    if(pc.readable()) 
        {
        Car = pc.getc();
        if (Car == 'E')
            {
            myled = 1;
            wait(0.1);
            }
        myled = 0;
        Car = '\0';
        }

    }
}
