#include "mbed.h"

// By: www.emcu.it
// For more detailed; schematics, explanations, etc, see: 
//      http://www.emcu.it/NUCLEOevaBoards/Nucleo-L152RE-AutomaticSlidingGate/AutomSlidGate.html

/*
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


//  Up to now the automatic closure start after 10sec. This because is not implemented the TbC.
//  Up to now the the following functions are not implemented:
//      AT (AntiTamper)
//      TbC
//      TempCurLight and consequently the ReleLight
//      LightSensor
//      SensCrep
//

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------
 
Serial pc(SERIAL_TX, SERIAL_RX);

Timeout to1; // Interrupt use for flashing
Timeout to2; // Interrupt use for flashing the GREEN led that is on NUCLEO-L152RE board
Timeout to3; // Interrupt used for automatic reclosure


// ADC Signals
AnalogIn TempCurLight(PA_1);    // Value from a potentiometer that sets the turn-on time of the courtesy light
AnalogIn SensCrep(PA_0);        // Value from a potentiometer that sets the threshold for day and night
AnalogIn LightSensor(PA_4);     // Crepuscular sensor

// Input Signals
DigitalIn PP(PB_3);  
DigitalIn FOTO(PB_5);  
DigitalIn EMERGENCY(PB_4);  
DigitalIn FCA(PA_7);
DigitalIn FCC(PA_6);
DigitalIn RA(PA_10);
DigitalIn BlueButton(USER_BUTTON);    // This is Blue-Button and is on NUCLEO-L153RE

// OutPut Signals
DigitalOut ReleLight(PB_10);
DigitalOut M1Com(PA_8);
DigitalOut M1Open(PA_9);
DigitalOut M1Close(PC_7);
DigitalOut Flashing(PB_6);
DigitalOut myled(LED1);     // This LED is on NUCLEO-L153RE

void SelfTest(void);
void TestPP(void);
void TestFCA(void);
void TestFCC(void);
void TestFOTO(void);
void TestEMERGENCY(void);
void TestRA(void);
void cb1(void);
void IntFlash(void);
void IntMyled(void);
void IntDLYforRA(void);

#define DLY 0.2 // Delay 200mS for Debounce
#define DLYFlash 0.6            // DLY for Flashing
#define DLYMyled 0.5    
#define DLYallarmFoto 0.2       // 0.2 == 200mS
#define DLYbeforeToStart 1.5    // 1.5 == 1,5sec
#define DLYforAutoReclosure 10  // 10 == 10sec
#define Pressed 0
#define NotPressed 1
#define OK 0
#define NotOK 1
#define FAIL 0
#define NotFAIL 1
#define YES 1
#define NoYES 0

#define OFF 0
#define ON 1
#define Opening 0
#define Closing 1
#define Undefine 3

int PP_mem = Pressed;   // Last value of PP
int EMERGENCY_mem = Pressed;
int FOTO_mem = OK; 
int FCA_mem = Pressed;
int FCC_mem = Pressed;
int RA_mem = ON;
uint16_t meas = 0;
uint16_t meas1 = 0;
uint16_t meas2 = 0;
int ONOFF_Flashing = OFF;
int LastMovement = Undefine;
int RA_OnOff = OFF;
int ChiudiBy_IntDLYforRA = OFF;


 
int main() 
  {

  // Turn on the InPut PullUp resistors
  // For more immunity connect a 4K7 PullUp resistor to the InPut pins.
  PP.mode(PullUp);
  FOTO.mode(PullUp);
  EMERGENCY.mode(PullUp);
  FCA.mode(PullUp);
  FCC.mode(PullUp);
  RA.mode(PullUp);

  to2.attach(&IntMyled, DLYMyled); // Enabling flassing GREEN led that is on NUCLEO-L152RE board
  //          Interrupt   Delay
  ONOFF_Flashing = OFF;
  
  to1.attach(&IntFlash, DLYFlash);  // Enabling flassing of FLASH lamp that indicate: GATE movement
  Flashing = 1; // Means Flashing Lamp OFF
  
  // to2.attach(&IntDLYforRA, DLYforAutoReclosure); // Enabling time for auto reclosure

  

  // If at PowerOn BlueButton is pressed is call the SelfTest routine  
  if (BlueButton == Pressed)
    SelfTest();   

  // MAIN Loop
  pc.printf("\n\r\n\rMAIN loop\n\r");
  
  while(1) 
  {
    TestFOTO();
    if (FOTO_mem == OK)
        ONOFF_Flashing = OFF;
    
    meas = TempCurLight.read_u16(); // Value from a potentiometer that sets the turn-on time of the courtesy light
    meas1 = SensCrep.read_u16();    // Value from a potentiometer that sets the threshold for day and night
    meas2 = LightSensor.read_u16(); // Crepuscular sensor
    // pc.printf("TempCurLight is:%d - SensCrep is:%d - LightSensor is:%d\n", meas, meas1, meas2);
    
    
    TestRA();   // Test the status of RA -> Automatic Reclosure
                // RA == 1 == Automatic Reclosure
                // RA == 0 == NO automatic reclosure
                // The delay before to close depend of the value of TbC

    
    // Test if there is the request for Auto Reclosure
    if (ChiudiBy_IntDLYforRA == ON)
        { 
        TestPP();
        TestFCC();
        TestFCA();
        TestFOTO();
        TestEMERGENCY();
        ChiudiBy_IntDLYforRA = OFF; // Disable the Auto Reclosure
        if (FCA_mem == Pressed & FOTO_mem == OK & EMERGENCY_mem == NotPressed)
            {
            pc.printf("Start to CLOSE\n\r");
            LastMovement = Closing;     // Memorizing the current CLOSING movement
            M1Com = ON;
            wait(0.1);
            M1Close = ON;
            wait(0.1);
            // Waiting FCC or PP Again)
            TestPP(); // Called for clean the buffer
            TestFOTO();
            while (FCC_mem == NotPressed & PP_mem == NotPressed & FOTO_mem == OK & EMERGENCY_mem == NotPressed)
                {
                TestEMERGENCY();
                TestFOTO();
                TestFCC();
                TestPP();
                }
            M1Com = OFF;
            wait(0.1);
            M1Close = OFF;
            wait(0.1);
            ONOFF_Flashing = OFF;
            if (FOTO_mem == NotOK)
                pc.printf("END CLOSE - STOP by FOTO ***\n\r");
            else if (EMERGENCY_mem == Pressed)
                pc.printf("END CLOSE - STOP by EMERGENCY ***\n\r");
            else
                pc.printf("END CLOSE\n\r");
            wait(1);
            } 
        }    
    
    
    // Test the status of PP
    TestPP();
    if (PP_mem == Pressed)
        {    
        ONOFF_Flashing = ON;
        to1.attach(&IntFlash, DLYFlash);  // Enabling flassing of FLASH lamp that indicate: GATE movement
        // Waiting the release of PP
        while(PP_mem == Pressed)
            TestPP();
        // Delay before start the gate
        wait(DLYbeforeToStart);
        
        // Test the status of FCC, FCA & FOTO
        TestFCA();
        TestFCC();
        TestFOTO();
        TestEMERGENCY();
        TestRA();
        
        pc.printf("FCA==%d - FCC==%d - FOTO==%d - EMERGENCY==%d - RA==%d\n\r", FCA_mem, FCC_mem, FOTO_mem, EMERGENCY_mem, RA_mem );
        
        // Check if must be OPEN
        if (FCC_mem == Pressed & FOTO_mem == OK & EMERGENCY_mem == NotPressed)
            {
            pc.printf("Start to OPEN\n\r");
            LastMovement = Opening;     // Memorizing the current OPENING movement
            M1Com = ON;
            wait(0.1);
            M1Open = ON;
            wait(0.1);
            // Waiting FCA or PP Again)
            TestPP(); // Called for clean the buffer
            while (FCA_mem == NotPressed & PP_mem == NotPressed & EMERGENCY_mem == NotPressed)
                {
                TestEMERGENCY();
                TestFCA();
                TestPP();
                }
            M1Com = OFF;
            wait(0.1);
            M1Open = OFF;
            wait(0.1);
            ONOFF_Flashing = OFF;
            if (EMERGENCY_mem == Pressed)
                pc.printf("END OPEN - STOP by EMERGENCY ***\n\r");
            else if (PP_mem == Pressed)
                pc.printf("END OPEN - STOP by PP ***\n\r");
            else
                {
                pc.printf("END OPEN\n\r");
                TestRA();
                if (RA_mem == ON)
                    {
                    RA_OnOff = ON;
                    to3.attach(&IntDLYforRA, DLYforAutoReclosure); // Enabling time for auto reclosure
                    }
                }
            wait(1);
            }
            
        // Check if must be CLOSE
        else if (FCA_mem == Pressed & FOTO_mem == OK & EMERGENCY_mem == NotPressed)
            {
            pc.printf("Start to CLOSE\n\r");
            LastMovement = Closing;     // Memorizing the current CLOSING movement
            M1Com = ON;
            wait(0.1);
            M1Close = ON;
            wait(0.1);
            // Waiting FCC or PP Again)
            TestPP(); // Called for clean the buffer
            TestFOTO();
            while (FCC_mem == NotPressed & PP_mem == NotPressed & FOTO_mem == OK & EMERGENCY_mem == NotPressed)
                {
                TestEMERGENCY();
                TestFOTO();
                TestFCC();
                TestPP();
                }
            M1Com = OFF;
            wait(0.1);
            M1Close = OFF;
            wait(0.1);
            ONOFF_Flashing = OFF;
            if (FOTO_mem == NotOK)
                pc.printf("END CLOSE - STOP by FOTO ***\n\r");
            else if (EMERGENCY_mem == Pressed)
                pc.printf("END CLOSE - STOP by EMERGENCY ***\n\r");
            else
                pc.printf("END CLOSE\n\r");
            wait(1);
            }            
         
        else if ( (LastMovement == Closing | LastMovement == Undefine) & (FOTO_mem == OK  & EMERGENCY_mem == NotPressed))
            {
            pc.printf("Start to OPEN\n\r");
            LastMovement = Opening;     // Memorizing the current OPENING movement
            M1Com = ON;
            wait(0.1);
            M1Open = ON;
            wait(0.1);
            // Waiting FCA or PP Again)
            TestPP(); // Called for clean the buffer
            while (FCA_mem == NotPressed & PP_mem == NotPressed & EMERGENCY_mem == NotPressed)
                {
                TestEMERGENCY();
                TestFCA();
                TestPP();
                }
            M1Com = OFF;
            wait(0.1);
            M1Open = OFF;
            wait(0.1);
            ONOFF_Flashing = OFF;
            if (EMERGENCY_mem == Pressed)
                pc.printf("END OPEN - STOP by EMERGENCY ***\n\r");
            else if (PP_mem == Pressed)
                pc.printf("END OPEN - STOP by PP ***\n\r");
            else
                {
                pc.printf("END OPEN\n\r");
                TestRA();
                if (RA_mem == ON)
                    {
                    RA_OnOff = ON;
                    to3.attach(&IntDLYforRA, DLYforAutoReclosure); // Enabling time for auto reclosure
                    }
                }
            wait(1);
            }
            
        else if ( LastMovement == Opening & FOTO_mem == OK  & EMERGENCY_mem == NotPressed)
            {
            pc.printf("Start to CLOSE\n\r");
            LastMovement = Closing;     // Memorizing the current CLOSING movement
            M1Com = ON;
            wait(0.1);
            M1Close = ON;
            wait(0.1);
            // Waiting FCC or PP Again)
            TestPP(); // Called for clean the buffer
            TestFOTO();
            while (FCC_mem == NotPressed & PP_mem == NotPressed & FOTO_mem == OK & EMERGENCY_mem == NotPressed)
                {
                TestEMERGENCY();
                TestFOTO();
                TestFCC();
                TestPP();
                }
            M1Com = OFF;
            wait(0.1);
            M1Close = OFF;
            wait(0.1);
            ONOFF_Flashing = OFF;
            if (EMERGENCY_mem == Pressed)
                pc.printf("END CLOSE - STOP by EMERGENCY ***\n\r");
            else
                pc.printf("END CLOSE\n\r");
            wait(1);
            }                  
        
        }
  }
}



// **************************** FUNCTIONS **************************************

// Flshing period for gate lamp indicator - It is define in DLYFlash
void IntFlash(void) { 
    if (ONOFF_Flashing == ON)
        Flashing = !Flashing;
    else
        Flashing = 1; // Means Flashing Lamp OFF
    to1.detach();
    if (FOTO_mem == NotOK)
        to1.attach(&IntFlash, DLYallarmFoto); // Highlight a problem on the FOTO (photocell) - this line reload Interrupt
    else
        to1.attach(&IntFlash, DLYFlash); // this line reload Interrupt
}


// Flashing Green LED that is on NUCLEO board
void IntMyled(void) { 
    myled = !myled;
    to2.detach();
    to2.attach(&IntMyled, DLYMyled); // this line reload Interrupt
}


// Time must be wait before do the automatic reclosure
void IntDLYforRA(void) { 
    if (RA_OnOff == ON)
        {
        pc.printf("Adesso deve partire la richiusura automatica\n\r");
        ChiudiBy_IntDLYforRA = ON;
        }
    to3.detach();
    // to2.attach(&IntDLYforRA, DLYforAutoReclosure); // this line reload Interrupt
}

// Test the status of FOTO and save it in FOTO_mem
void TestFOTO(void)
{
    if (FOTO == 0 & FOTO_mem == NotOK)
    { // FOTO is pressed, we do the delay for Debounce
      wait(DLY); 
      if (FOTO == 0)
      {
        FOTO_mem = OK;
        pc.printf("FOTO is OK (0)\n\r");
      }
      else
        FOTO_mem = NotOK;
    }
    if (FOTO == 1)
      FOTO_mem = NotOK;
}


// Test the status of EMERGENCY and save it in EMERGENCY_mem
void TestEMERGENCY(void)
{
    if (EMERGENCY == 0 & EMERGENCY_mem == NotPressed)
    { // EMERGENCY is pressed, we do the delay for Debounce
      wait(DLY); 
      if (EMERGENCY == 0)
      {
        EMERGENCY_mem = Pressed;
        pc.printf("EMERGENCY is PRESSED (0)\n\r");
      }
      else
        EMERGENCY_mem = NotPressed;
    }
    if (EMERGENCY == 1)
      EMERGENCY_mem = NotPressed;
}


// Test the status of RA and save it in RA_mem
void TestRA(void)
{
    if (RA == 0 & RA_mem == ON)
    { // RA is OFF (0), we do the delay for Debounce
      wait(DLY); 
      if (RA == 0)
      {
        RA_mem = OFF;
        pc.printf("RA is OFF (0)\n\r");
      }
      else
        RA_mem = ON;
    }
    if (RA == 1)
      RA_mem = ON;
}


// Test the status of FCC and save it in FCC_mem
void TestFCC(void)
{
    if (FCC == 0 & FCC_mem == NotPressed)
    { // FCC is pressed, we do the delay for Debounce
      wait(DLY); 
      if (FCC == 0)
      {
        FCC_mem = Pressed;
        pc.printf("FCC is PRESSED (0)\n\r");
      }
      else
        FCC_mem = NotPressed;
    }
    if (FCC == 1)
      FCC_mem = NotPressed;
}


// Test the status of FCA and save it in FCA_mem
void TestFCA(void)
{
    if (FCA == 0 & FCA_mem == NotPressed)
    { // FCA is pressed, we do the delay for Debounce
      wait(DLY); 
      if (FCA == 0)
      {
        FCA_mem = Pressed;
        pc.printf("FCA is PRESSED (0)\n\r");
      }
      else
        FCA_mem = NotPressed;
    }
    if (FCA == 1)
      FCA_mem = NotPressed;
}   


// Test the status of PP and save it in PP_mem
void TestPP(void)
{
    // Test PP
    if (PP == 0 & PP_mem == NotPressed)
    { // PP is pressed, we do the delay for Debounce
      wait(DLY); 
      if (PP == 0)
      {
        PP_mem = Pressed;
        pc.printf("PP is PRESSED (0)\n\r");
      }
      else
        PP_mem = NotPressed;
    }
    if (PP == 1)
      PP_mem = NotPressed;
}



// Function for testing I/O and ADC used in the program ***********************
void SelfTest(void)
  {
  pc.printf("\n\rProgram for Test CancSCO I/O and ADC\n\r");
  pc.printf("ADC test, press PP for exit from ADC test\n\r");
  
  while(PP == NotPressed)
  {
    meas = TempCurLight.read_u16(); // Converts and read the analog input value
    meas1 = SensCrep.read_u16(); // Converts and read the analog input value
    meas2 = LightSensor.read_u16(); // Converts and read the analog input value
    pc.printf("TempCurLight is:%d - SensCrep is:%d - LightSensor is:%d\n\r", meas, meas1, meas2);
    wait(2);     
  }
  
  pc.printf("I/O test, press EMERGENCY for exit from I/O test\n\r");
  while(EMERGENCY == NotPressed) 
  {
    // Test OutPut pin ********************************
    if (BlueButton == Pressed)
    {
        pc.printf("Sequence for testing OutPut\n\r");
        ReleLight = 1;
        wait(0.5);
        ReleLight = 0;
        M1Com = 1;
        wait(0.5);
        M1Com = 0;
        M1Open = 1;
        wait(0.5);
        M1Open = 0;
        M1Close = 1;
        wait(0.5);
        M1Close = 0;
        Flashing = 1;
        wait(0.5);
        Flashing = 0;
    }
    // END - Test OutPut pin **************************
    
    
    // Test Input Signals *****************************
    
    // Test FCA
    if (FCA == 0 & FCA_mem == NotPressed)
    { // FCA is pressed, we do the delay for Debounce
      wait(DLY); 
      if (FCA == 0)
      {
        M1Close = 1;
        FCA_mem = Pressed;
        pc.printf("FCA is PRESSED (0)\n\r");
      }
      else
        FCA_mem = NotPressed;
    }
    if (FCA == 1)
    {
      FCA_mem = NotPressed;
      M1Close = 0; 
    }    
    
    // Test FCC
    if (FCC == 0 & FCC_mem == NotPressed)
    { // FCC is pressed, we do the delay for Debounce
      wait(DLY); 
      if (FCC == 0)
      {
        Flashing = 1;
        FCC_mem = Pressed;
        pc.printf("FCC is PRESSED (0)\n\r");
      }
      else
        FCC_mem = NotPressed;
    }
    if (FCC == 1)
    {
      FCC_mem = NotPressed;
      Flashing = 0; 
    } 
    
    // Test PP
    if (PP == 0 & PP_mem == NotPressed)
    { // PP is pressed, we do the delay for Debounce
      wait(DLY); 
      if (PP == 0)
      {
        ReleLight = 1;
        PP_mem = Pressed;
        pc.printf("PP is PRESSED (0)\n\r");
      }
      else
        PP_mem = NotPressed;
    }
    if (PP == 1)
    {
      PP_mem = NotPressed;
      ReleLight = 0; 
    }
    
    // Test FOTO
    if (FOTO == 0 & FOTO_mem == NotOK)
    { // FOTO is pressed, we do the delay for Debounce
      wait(DLY); 
      if (FOTO == 0)
      {
        M1Com = 1;
        FOTO_mem = OK;
        pc.printf("FOTO is ACTIVE (0)\n\r");
      }
      else
        FOTO_mem = NotOK;
    }
    if (FOTO == 1)
    {
      FOTO_mem = NotOK;
      M1Com = 0; 
    }
    
    // Test EMERGENCY
    if (EMERGENCY == 0 & EMERGENCY_mem == NotPressed)
    { // EMERGENCY is pressed, we do the delay for Debounce
      wait(DLY); 
      if (EMERGENCY == 0)
      {
        M1Open = 1;
        EMERGENCY_mem = Pressed;
        pc.printf("EMERGENCY is PRESSED (0)\n\r");
      }
      else
        EMERGENCY_mem = NotPressed;
    }
    if (EMERGENCY == 1)
    {
      EMERGENCY_mem = NotPressed;
      M1Open = 0; 
    }      
    // END - Test Input Signals **************************
  } 
} 
// END - Function for testing I/O and ADC used in the program ***********************

// **************************** END FUNCTIONS ***************************************
