
// By: www.emcu.it
// See also here: http://www.emcu.it/NUCLEOevaBoards/NUCLEOevaBoards.html
//
//   Arduino LCD KeyPad Shield 
//      Model: 1602 LCD and 6 AD buttons for Arduino
//      http://www.robot-italy.com/it/1602-lcd-shield.html
//
//
/*
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


#include "mbed.h"
#include "TextLCD.h"

DigitalOut myled(LED1);

//
// SetUp GPIO for drive the LCD
//
//  LCD (RS, E, D4, D5, D6, D7)
TextLCD lcd(PA_9, PC_7, PB_5, PB_4, PB_10, PA_8); // LCD Shield for Arduino
AnalogIn button(PA_0);  // board button
PwmOut backlight(PB_6);


/***
 * -------------------------------------------------
 *   Arduino LCD KeyPad Shield 
 *      Model: 1602 LCD and 6 AD buttons for Arduino
 * -------------------------------------------------
 *  - Button            : a0  -> PA0
 *                                 right  : 0x000
 *                                 up     : < 0x3ff
 *                                 down   : < 0x7ff
 *                                 left   : < 0xbff
 *                                 select : 0xfff
 * ---------------------------------------------
 *  - DB4               : D4  -> PB_5
 *  - DB5               : D5  -> PB_4
 *  - DB6               : D6  -> PB_10
 *  - DB7               : D7  -> PA_8
 *  - RS                : D8  -> PA_9
 *  - Enable            : D9  -> ptd5
 *  - Backlight Control : D10 -> PB_6
 * ---------------------------------------------
 *  - http://www.robot-italy.com/it/1602-lcd-shield.html
 *
***/

#define ON  1
#define OFF 0

int main()
{

    backlight = ON;  // ON: 1, OFF: 0
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("By: www.emcu.it");
    wait(2);

    while (1)
    {
        myled = !myled;


        // READ BUTTON VALUE
        unsigned long value = button.read_u16();

        // LCD OUTPUT
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("By: www.emcu.it");

        lcd.locate(0,1);
        lcd.printf("BUTTON : %04x", value);  // button value
        
        // Test the Push Button on LCD
        if (value < 0x3ff)       // up
            backlight = ON;
        else if (value < 0x7ff)  // down
            backlight = OFF;            
        else;
        wait(0.2);
    }
}
