/*

  By: www.emcu.it

  NUCLEO-L152RE and AUREL RTX-MID-3V 

  AUREL RTX-MID-3V 
  Italian AUREL manual is here: http://www.aurelwireless.com/wp-content/uploads/manuale-uso/650201033G_mu.pdf
  English AUREL manual is here: http://www.aurelwireless.com/en/radiomodem-data-transceivers/ 
  https://www.futurashop.it/index.php?route=product/product&filter_name=RTX-MID-3V&product_id=2788

  CONNECTIONS from AUREL RTX-MID-3V to NUCLEO L152RE
  PIN1    Antenna 17cm
  PIN2    GND
  PIN4    TX connected to TX on NUCLEO L152RE
  PIN5    Tx/Rx connected to PA_10 on NUCLEO L152RE 
  PIN6    ENABLE connected to PB_3 on NUCLEO L152RE
  PIN7    GND
  PIN8    Analog Out not connected
  PIN9    RX connected to RX on NUCLEO L152RE
  PIN10   VCC connected to 3,3V on NUCLEO L152RE
  
  NOTE: from GND and VCC put a capacitor of 0,1uF and a second capacitor of 10uF

    
    ********** IMPORTANT IMPORTANT IMPORTANT IMPORTANT **********
    
    This project use the USART for this reason you must do the below modifications 
    on NUCLEO-L152RE, more info are here:
    http://www.emcu.it/NUCLEOevaBoards/U2andL152/U2andL152.html#USART2_for_communication_with_shield_or
    
    Put a jumper on SB62 and another on SB63
    Remove a 0 ohm resistor from SB13 and SB14
    
    After this modifications, you lost the possibility to use the virtual comm to connect 
    the NUCLEO to the PC.

    *************************************************************  
  
    
    ********** EXPLANATIONS:
    
    If you build two boards identically when you press a Blue button on the board n.1, 
    the green LED flashing, release the Blue button and the transmission is started.
    On the board n.2 the green LED is turn on (for 3 sec) and an ACK is send to board n.1.
    After some second, on the board n.1, the green LED is turn on (for 3 sec) to indicate 
    that the command sent to the board n.2 was received correctly.
    

 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 
 
 */


#include "mbed.h"

Serial pc(SERIAL_TX, SERIAL_RX);    // tx, rx
DigitalOut RTX_DIR(PA_10);          // 1 == TX  0 == RX
DigitalOut RTX_Enable(PB_3);        // 1 == RTX enable  0 == RTX disable

DigitalOut myled(LED1);                 // This LED is on NUCLEO-L152RE
DigitalIn BlueButton(USER_BUTTON);      // This is Blue-Button and is on NUCLEO-L153RE

#define Pressed 0
#define NotPressed 1
#define Enable 1
#define Disable 0
#define ACK 2
#define OK 1
#define FAIL 0

#define ON  1
#define OFF 0
#define TX 1
#define RX 0

int Car='\0';
int RisultatoRX=FAIL;


int TestRX_Data(void);
void RTX_StartUp(void);
void RTX_PowerDown(void);
void RTX_PowerON(void);
void RTX_TX(void);
void RTX_RX(void);

int CarStr[3];
int PuntCar = 0;

void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    Car = pc.getc();
    if (PuntCar < 3)
        {
        CarStr[PuntCar] = Car;
        PuntCar++;
        }
}


int main()
{
    int n=0;
    
    pc.baud(1200);
    pc.attach(&callback, pc.RxIrq); // It is for reading under Interrupt the RX from USART
    
    // Start Up of the RTX-MID and put it in RX mode
    RTX_StartUp();
    
    while (1)
    {
       
        if (BlueButton == Pressed)
            { 
            while (BlueButton == Pressed)
                {
                myled = !myled;
                wait(0.2);
                }
            myled = OFF;
            
            for (n=0; n<20; n++)
                {    
                RTX_TX();           // RTX-MID on TX mode        
                // Send Message
                pc.printf("#?@");   // Send Command
                wait_ms(100); 
                RTX_RX();           // RTX-MID on RX mode
                
                // Test if the Message is arrived
                RisultatoRX = TestRX_Data();
                if (RisultatoRX == OK)
                    {
                    myled = ON;
                    wait(3);
                    }
                else
                    myled = OFF;                
                }           
            RTX_RX(); // RTX-MID on RX mode
            }
        
        // Decode Message
        // 0==FAIL  1==OK  2==ACK
        RisultatoRX = TestRX_Data();
        if (RisultatoRX == OK)
            {
            myled = ON;
            // Send ACK
            for (n=0; n<10; n++)
                {
                RTX_TX();           // RTX-MID on TX mode
                pc.printf("#K@");   // Send ACK
                wait_ms(100);              
                }
            wait(1);
            // Send ACK
            for (n=0; n<20; n++)
                {
                RTX_TX();           // RTX-MID on TX mode           
                pc.printf("#K@");   // Send ACK
                wait_ms(100);              
                }
            RTX_RX();   // RTX-MID on RX mod
            }
        else if (RisultatoRX == ACK)
            { 
            myled = ON;
            wait(3);
            RTX_RX();   // RTX-MID on RX mod
            }                       
        else
            myled = OFF;   
                      
    }
}

//
// *************************************************************
//


//
// Decode Message
//
// REMEMBER: 
// before to use this function must put in RX mode the RTX
//
int TestRX_Data(void)
    {
    int OkFail=0; // 0==FAIL  1==OK  2==ACK
    
    if (CarStr[0]=='#' & CarStr[1]=='?' & CarStr[2]=='@')   
        OkFail=1; // OK                
    else if (CarStr[0]=='#' & CarStr[1]=='K' & CarStr[2]=='@') 
        OkFail=2; // ACK 
    else;
         
    if (PuntCar >= 3) // Reset the CarStr & PuntCar
        { 
        CarStr[0] = '0';
        CarStr[1] = '1';
        CarStr[2] = '2';
        PuntCar = 0;                  
        }
        
    return OkFail;         
    }
    
    
    
void RTX_StartUp(void)
    {
    RTX_Enable = Disable;
    wait_ms(10);        
    RTX_Enable = Enable;
    wait_ms(1); 
    RTX_DIR = TX;     // RTX-MID in TX mode
    wait_ms(1);       // Wait the stabilizzation of the transceiver
    RTX_Enable = Disable;
    wait_ms(10);        
    RTX_Enable = Enable;
    wait_ms(1);                                            
    RTX_DIR = RX;     // RTX-MID in RX mode
    wait_ms(1);       // Wait the stabilizzation of the transceiver             
    RTX_Enable = Disable;
    wait_ms(1);
    RTX_Enable = Enable;
    wait_ms(1);         
    }

void RTX_PowerDown(void)
    {
    RTX_Enable = Disable;
    wait_ms(10);
    }
    
void RTX_PowerON(void)
    {
    RTX_Enable = Disable;
    wait_ms(1);
    }    
    
void RTX_TX(void)
    {
    RTX_Enable = Disable;
    wait_ms(10); 
    RTX_Enable = Enable;
    wait_ms(1);        
    RTX_DIR = TX;     // RTX-MID in TX mode
    wait_ms(10);      // Wait the stabilizzation of the transceiver     
    }        

void RTX_RX(void)
    {
    RTX_Enable = Disable;
    wait_ms(10); 
    RTX_Enable = Enable;
    wait_ms(1);  
    RTX_DIR = TX;     // RTX-MID in TX mode
    wait_ms(1);       // Wait the stabilizzation of the transceiver
    RTX_DIR = RX;     // RTX-MID in RX mode
    wait_ms(1);
    RTX_Enable = Disable;
    wait_ms(10);       
    RTX_Enable = Enable; 
    wait_ms(1);                                                             
    }
    
