//
// U2andU1_Inter
//
// From: www.emcu.it
// Date: 29-06-2014
// Tested on NUCLEO_L152RE
// for more info see here: http://www.emcu.it/NUCLEOevaBoards/NUCLEOevaBoards.html#Tutorial
//
/*
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 
 
 ++++++++++++++++++++++ CONFIGURATIONS +++++++++++++++++++++++++++++++
 
 USART2 it is used for debug (connected to the PC) using TeraTerm
 USART1 it is used for show the way to use another USART
 Both USART are not used under Interrupt
 
 The USART parameters are:
 Baud Rate: 115200 
 Data: 8
 Parity: NONE
 Stop: 1
 Flow Control: NONE
  
  
 ++++++++++++++++++++++ How to use this example ++++++++++++++++++++++
 
 For test this example connect with a jumper D2 (SERIAL1_RX) to D10 (SERIAL1_TX).
 
 Press and release the Blue Button and you must see the green LED ON for 1 second. 
 At the same time some message are displayed via USB Virtual COM on your PC.
 
 Similar, if you press E on your Tera Term (PC) you must see the green LED ON for 1 second.
 
 
 */

#include "mbed.h"
 
Serial pc(SERIAL_TX, SERIAL_RX);    // This is USART2 tx, rx
                                    //      It is used for Debug via VirtualCOM 
                                    //      I suggest to use Tera TERM on PC
Serial Serial1(PB_6, PA_10);        // This is USART1 tx, rx
DigitalOut myled(LED1);             // This LED is on NUCLEO-L152RE
DigitalIn BlueButton(USER_BUTTON);  // This is Blue-Button and is on NUCLEO-L153RE

#define Pressed 0
#define NotPressed 1

int Car='\0';
int CarSerial1='\0';
int n=0;

void callback2() // USART2 used for Debug
    {
    // Note: you need to actually read from the serial to clear the RX interrupt
    Car = pc.getc();
    }
 
void USART1_INT() // USART1
    {
    // Note: you need to actually read from the serial to clear the RX interrupt
    CarSerial1 = Serial1.getc();
    }


int main() {
    myled = 0;
    
    // SetUp the baud rate
    pc.baud(115200);
    Serial1.baud(115200);

    Serial1.attach(&USART1_INT);
    pc.attach(&callback2);
    
    pc.printf("\n\r\n\r START MAIN \n\r");
    
    while(1) 
    {
    
    // Test the Blue Button
    if (BlueButton == Pressed)
        {
        while(BlueButton == Pressed)
            {
            if (n == 0)
                pc.printf("Please release the BLUE Button\n\r");
            n++;
            }
        n = 0;
        pc.printf("Send char. E to USART1\n\r");
        Serial1.putc('E');      // Send char. E to USART1
        }
       
    // Test the char. received from USART2 that is USB Virtual COM 
    if (Car == 'E')
        {
            {
            pc.printf("Send char. E (received from USB_VirtualCOM USART2) to USART1\n\r");
            Serial1.putc('E');  // Send char. E to USART1
            }
        Car = '\0';
        }
    
    // Test the char. received from USART1
    if (CarSerial1 == 'E')
        {
            {
            pc.printf("RX char. E from USART1\n\r");
            myled = 1;
            wait(1);
            }
        myled = 0;
        CarSerial1 = '\0';
        }        

    }
}
