
/**

    NUCLEO-F401RE + DS18B20 + Thermistor
    Thermistor response, not fully tested.

By:       www.emcu.it
Date:     Jan.2015
Version:  1.0
Name:     NUCLEO-F401RE-DS1820andThermistorNTC10K
NOTE:     For more info see here: http://www.emcu.it/NUCLEOevaBoards/mBed/QSG-Mbed-Library.pdf

THE SOFTWARE AND HARDWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
FITNESS FOR A PARTICULAR PURPOSE AND NON INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS 
OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

UART Configuration (It is necessary for see the results, we suggest to use TeraTerm on PC)  
    Baud Rate:    9600 
    Data Bit:     8
    Parity:       NONE
    Stop Bit:     1
    Flow Control: NONE
    
This SW is ready to use on the NUCLEO-F334R8.
Connect to the NUCLEO-F334R8 the DS18B20 sensor (see the schematic below).
The temperature sampling time is 1 sec.

 DS18B20 front view
    __________
   |          |
   |    DS    |
   |   18B20  |   
   |          |
   |__________|
     |   |   |
     1   2   3
    GND  DQ VCC (3V3)
     |   |   |______________ to VCC (3.3V on the NUCLEO-F401RE)  
     |   |  _|_
     |   |  | |
     |   |  | | 4K7
     |   |  | |
     |   |  -|-
     |   |___|______________ to A1 (on the NUCLEO-F401RE) 
     |
     |
     |______________________ to GND (on the NUCLEO-F401RE)   

This SW is just for only one DS18B20
This SW is a derivative of:: https://developer.mbed.org/users/Sissors/code/DS1820_HelloWorld/
On the: https://developer.mbed.org/users/Sissors/code/DS1820_HelloWorld/ there is a multi sensor (DS18B20) example.

 Thermistor of 10K - For calculate the temperature we use the Steinhart-Hart equation, see here:
                     http://www.emcu.it/RaspBerryPi/RaspBerryPi_UK.html#Misura_NTC
                     
      
        ___________________ to VCC (3.3V on the NUCLEO-F401RE)
       |  
      _|_
      | |
      | | 10K Thermistor (NTC)
      | |
      -|-
       |___________________ to A5 (on the NUCLEO-F401RE)
      _|_        |
      | |        |
      | | 10K   _|_ 
      | |       ___  0,47uF
      -|-        |
       |         |
       |_________|_________ to GND (on the NUCLEO-F401RE)
       
       
*/



#define MULTIPLE_PROBES
#define DATA_PIN        A1

#ifdef MULTIPLE_PROBES

#include "mbed.h"
#include "DS1820.h"

#define MAX_PROBES      16

float get_temperature(void);

AnalogIn thermistor(A5); // Thermistor

float temp=0;
float tempArr[100];
int n=0;

DS1820* probe[MAX_PROBES];
 
int main() {  
    // Initialize the probe array to DS1820 objects
    int num_devices = 0;
    while(DS1820::unassignedProbe(DATA_PIN)) {
        probe[num_devices] = new DS1820(DATA_PIN);
        num_devices++;
        if (num_devices == MAX_PROBES)
            break;
    }
    
    printf("Found %d device(s)\r\n\n", num_devices);
    while(1) 
    {
        probe[0]->convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        for (int i = 0; i<num_devices; i++)
            printf("Device %d returns %3.3foC\r\n", i, probe[i]->temperature());
    
        for(n=0; n<100; n++)
        {
            tempArr[n]=get_temperature();
            wait_ms(10);
        }
        temp=0;
        for(n=0; n<100; n++)
            temp=temp + tempArr[n];
        temp=temp/100;
        printf("NTC returns      %3.3foC\r\n\n\r", temp);
        
        wait(1);
    }
    
}

#else
#include "mbed.h"
#include "DS1820.h"
 
DS1820 probe(DATA_PIN);
 
int main() {
    while(1) {
        probe.convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        printf("It is %3.3foC\r\n", probe.temperature());
        wait(1);
    }
}

#endif

/*
 Thermistor (NTC) of 10K - For calculate the temperature we use the Steinhart-Hart equation, see here:
                     http://www.emcu.it/RaspBerryPi/RaspBerryPi_UK.html#Misura_NTC
 ATTENTION: Thermistor response, not fully tested.
*/
float get_temperature(void)
{
    unsigned int a, beta = 3975;
    float temperature, resistance;
    
    a = thermistor.read_u16();
    
    /* Calculate the resistance of the thermistor from analog votage read. */
    resistance = (float) 10000.0 * ((65536.0 / a) - 1);
    
    /* Convert the resistance to temperature using Steinhart's Hart equation */
    temperature=(1/((log(resistance/10000.0)/beta) + (1.0/298.15)))-273.15; 
    
    return temperature;
}
