/*
    
    Countdown Timer from 1 to 199 minutes
    
    STM32F7-Discovery Demo by www.emcu.it
    
    Date: Feb.2016
    Ver.: 1.0.5

*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*

*/

#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include <string>

// LCD color
#define LCD_BLUE          ((uint32_t)0xFF0000FF)
#define LCD_GREEN         ((uint32_t)0xFF00FF00)
#define LCD_RED           ((uint32_t)0xFFFF0000)
#define LCD_CYAN          ((uint32_t)0xFF00FFFF)
#define LCD_MAGENTA       ((uint32_t)0xFFFF00FF)
#define LCD_YELLOW        ((uint32_t)0xFFFFFF00)
#define LCD_LIGHTBLUE     ((uint32_t)0xFF8080FF)
#define LCD_LIGHTGREEN    ((uint32_t)0xFF80FF80)
#define LCD_LIGHTRED      ((uint32_t)0xFFFF8080)
#define LCD_LIGHTCYAN     ((uint32_t)0xFF80FFFF)
#define LCD_LIGHTMAGENTA  ((uint32_t)0xFFFF80FF)
#define LCD_LIGHTYELLOW   ((uint32_t)0xFFFFFF80)
#define LCD_DARKBLUE      ((uint32_t)0xFF000080)
#define LCD_COLOR_DARKGREEN     ((uint32_t)0xFF008000)
#define LCD_COLOR_DARKRED       ((uint32_t)0xFF800000)
#define LCD_COLOR_DARKCYAN      ((uint32_t)0xFF008080)
#define LCD_COLOR_DARKMAGENTA   ((uint32_t)0xFF800080)
#define LCD_COLOR_DARKYELLOW    ((uint32_t)0xFF808000)
#define LCD_COLOR_WHITE         ((uint32_t)0xFFFFFFFF)
#define LCD_COLOR_LIGHTGRAY     ((uint32_t)0xFFD3D3D3)
#define LCD_COLOR_GRAY          ((uint32_t)0xFF808080)
#define LCD_COLOR_DARKGRAY      ((uint32_t)0xFF404040)
#define LCD_COLOR_BLACK         ((uint32_t)0xFF000000)
#define LCD_COLOR_BROWN         ((uint32_t)0xFFA52A2A)
#define LCD_COLOR_ORANGE        ((uint32_t)0xFFFFA500)
#define LCD_COLOR_TRANSPARENT   ((uint32_t)0xFF000000)

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
DigitalOut led1(LED1);

int pos = 1;
// uint8_t min = 45;
uint8_t _min = 45;
uint8_t Mem_min = 45;
uint16_t xpos=20, ypos=5;
int n=0;
int tcount = 45;


void Logo(void);
void FillBox(uint32_t color, int x, int y, int larg, int alt);
void DisplayBigNumber(uint8_t Numero);
void VisNumber(int x, int y, uint32_t color, uint8_t v, uint32_t colorBackground);
void draw1(int x, int y, uint32_t color);
void draw2(int x, int y, uint32_t color);
void draw3(int x, int y, uint32_t color);
void draw4(int x, int y, uint32_t color);
void draw5(int x, int y, uint32_t color);
void draw6(int x, int y, uint32_t color);
void draw7(int x, int y, uint32_t color);
void draw8(int x, int y, uint32_t color);
void draw9(int x, int y, uint32_t color);
void draw0(int x, int y, uint32_t color);

int main()
{  
    led1 = 1;
    
    TS_StateTypeDef TS_State;

    uint16_t x, y;
    uint8_t idx;
    uint8_t text[30];
    int Count=0;
    int Minuti=0;
    int n=0;
   
    
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
  
    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"                         ", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"   By:  www.emcu.it      ", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"                         ", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(3), (uint8_t *)"   Written using mBed    ", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(4), (uint8_t *)"                         ", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"   Touch the screen      ", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"   for continue.         ", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"                         ", CENTER_MODE);
  
    /*
    draw1(10, 200, LCD_YELLOW);
    draw2(60, 200, LCD_GREEN);
    draw3(110, 200, LCD_RED);
    draw4(160, 200, LCD_BLUE);
    draw5(210, 200, LCD_CYAN);
    draw6(260, 200, LCD_YELLOW);
    draw7(310, 200, LCD_GREEN);
    draw8(360, 200, LCD_RED);
    draw9(410, 200, LCD_BLUE);
    draw0(10,  200, LCD_CYAN);
    */
    
    ts.GetState(&TS_State);
    while(TS_State.touchDetected == 0)
        {
        ts.GetState(&TS_State);
        }
 
// ReStart:
            
    while(1)
      {
        lcd.SetFont(&Font24);
        lcd.SetBackColor(LCD_COLOR_BLUE);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)" By: www.emcu.it         ", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(1), (uint8_t *)" Touch the screen for:   ", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)" LEFT   for decrease MIN ", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(3), (uint8_t *)" RIGHT  for increase MIN ", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(4), (uint8_t *)" REDbox for start TIMER  ", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"                         ", CENTER_MODE);
        lcd.SetBackColor(LCD_COLOR_BLACK);
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"                         ", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"                         ", CENTER_MODE);
        lcd.SetBackColor(LCD_COLOR_BLUE);
        lcd.SetTextColor(LCD_COLOR_WHITE);        
        sprintf((char*)text, " MIN: %d ", _min);
        lcd.DisplayStringAt(xpos, LINE(7), (uint8_t *)&text, LEFT_MODE);
        
        // Draw the RED box that indicate the area to touch for start Timer
        FillBox(0xFFFF0000, (lcd.GetXSize()/2)-25, 200, 50, 50);        
        
        // Whait touch        
        ts.GetState(&TS_State);
        while(TS_State.touchDetected == 0)
            {
            ts.GetState(&TS_State);
            }
        
        
        // Increment
        ts.GetState(&TS_State);
        if ((TS_State.touchDetected) && (TS_State.touchX[0] > 400))
            {
            _min++;
            if (_min>199)
                _min=199;
            lcd.SetBackColor(LCD_COLOR_BLUE);
            lcd.SetTextColor(LCD_COLOR_WHITE);                
            sprintf((char*)text, " MIN: %d ", _min);
            lcd.DisplayStringAt(xpos, LINE(7), (uint8_t *)&text, LEFT_MODE);
            }
        // Decrement
        ts.GetState(&TS_State);
        if ((TS_State.touchDetected) && (TS_State.touchX[0] < 200))
            {
            _min--;
            if (_min<1)
                _min=1;
            lcd.SetBackColor(LCD_COLOR_BLUE);
            lcd.SetTextColor(LCD_COLOR_WHITE);                
            sprintf((char*)text, " MIN: %d ", _min);
            lcd.DisplayStringAt(xpos, LINE(7), (uint8_t *)&text, LEFT_MODE);
            }            
            
        // Whait touch        
        ts.GetState(&TS_State);
        while(TS_State.touchDetected == 0)
            {
            ts.GetState(&TS_State);
            }
                        
        wait(0.1);
        
        // Draw the RED box that indicate the area to touch for start Timer
        FillBox(0xFFFF0000, (lcd.GetXSize()/2)-25, 200, 50, 50);
        
        Count=0;
        
        // Get the touch position for Start Timer
        for (idx = 0; idx < TS_State.touchDetected; idx++) 
            {        
            x = TS_State.touchX[idx];
            y = TS_State.touchY[idx];
            if ((x>((lcd.GetXSize()/2)-25)) & (x<((lcd.GetXSize()/2)+25)) && (y>175 & y<225))
                {
                lcd.Clear(LCD_COLOR_BLACK);
                lcd.SetFont(&Font24);
                lcd.SetBackColor(LCD_COLOR_BLACK);
                lcd.SetTextColor(LCD_COLOR_WHITE);                
                sprintf((char*)text, " Minutes that remain:  %d ", _min);
                lcd.DisplayStringAt(xpos, LINE(5), (uint8_t *)&text, LEFT_MODE);
                Logo();
                                
                tcount=_min;
                tcount=tcount*60;
                Mem_min=_min;
                Minuti=0;
                for (n=0; n<tcount; n++)
                    {
                    wait(1); // 60 == 1min
                    
                    // Show an * for highlight that the program is running
                    Count++;
                    if (Count == 1)
                        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"*", CENTER_MODE);                                                                    
                    if (Count == 2)
                        {
                        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)" ", CENTER_MODE);                     
                        Count=0;
                        }
                     
                    // Counter for minutes   
                    Minuti++;
                    if (Minuti==60)
                        {
                        _min--;
                        Minuti=0;
                        }
                    else;
                    
                    // Display the time remaining
                    if (_min < 10)
                        {
                        //lcd.Clear(LCD_COLOR_RED);
                        lcd.SetFont(&Font24);                    
                        lcd.SetBackColor(LCD_COLOR_RED);
                        lcd.SetTextColor(LCD_COLOR_WHITE);                    
                        sprintf((char*)text, " Minutes that remain:  %d ", _min);
                        lcd.DisplayStringAt(xpos, LINE(5), (uint8_t *)&text, LEFT_MODE);
                        if (Count == 0)
                            // Clear 1Â° cifra
                            FillBox(LCD_COLOR_BLACK, 300, 200, 40, 70);
                        else
                            DisplayBigNumber(_min);
                        Logo();                             
                        }
                    else
                        {
                        //lcd.Clear(LCD_COLOR_BLACK);
                        lcd.SetFont(&Font24);                    
                        lcd.SetBackColor(LCD_COLOR_BLACK);
                        lcd.SetTextColor(LCD_COLOR_WHITE);                    
                        sprintf((char*)text, " Minutes that remain:  %d ", _min);
                        lcd.DisplayStringAt(xpos, LINE(5), (uint8_t *)&text, LEFT_MODE);
                        DisplayBigNumber(_min);
                        Logo();     
                        }             
                    }
                
                _min=Mem_min;
                lcd.SetFont(&Font24);
                
                lcd.Clear(LCD_COLOR_BLACK);
                lcd.SetFont(&Font24);
                
                // Highlight the end of time            

                // Waiting Touch the screen for restart the program
                ts.GetState(&TS_State);
                while(TS_State.touchDetected == 0)
                    {
                    lcd.Clear(LCD_COLOR_RED);
                    lcd.SetBackColor(LCD_COLOR_RED);                                       
                    lcd.SetTextColor(LCD_COLOR_WHITE);         
                    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"                           ", CENTER_MODE);           
                    lcd.DisplayStringAt(0, LINE(3), (uint8_t *)" END time...               ", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(4), (uint8_t *)" STOP the presentation !!! ", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"                           ", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"                           ", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(7), (uint8_t *)" Touch screen to restart   ", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"                           ", CENTER_MODE);                    
                    wait(0.5);
                    
                    lcd.Clear(LCD_COLOR_BLUE);
                    lcd.SetBackColor(LCD_COLOR_BLUE);                                       
                    lcd.SetTextColor(LCD_COLOR_WHITE);         
                    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"                           ", CENTER_MODE);           
                    lcd.DisplayStringAt(0, LINE(3), (uint8_t *)" END time...               ", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(4), (uint8_t *)" STOP the presentation !!! ", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"                           ", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"                           ", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(7), (uint8_t *)" Touch screen to restart   ", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"                           ", CENTER_MODE);                      
                    wait(0.5);
                    
                    ts.GetState(&TS_State);
                    }
                
                
                
                lcd.Clear(LCD_COLOR_BLACK);
                lcd.SetTextColor(LCD_COLOR_WHITE);         
                lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"                           ", CENTER_MODE);           
                lcd.DisplayStringAt(0, LINE(3), (uint8_t *)"                           ", CENTER_MODE);
                lcd.DisplayStringAt(0, LINE(4), (uint8_t *)" Remove your finger from   ", CENTER_MODE);
                lcd.DisplayStringAt(0, LINE(5), (uint8_t *)" the screen                ", CENTER_MODE);
                lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"                           ", CENTER_MODE);
                lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"                           ", CENTER_MODE);
                lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"                           ", CENTER_MODE); 
                // Whait remove touch        
                ts.GetState(&TS_State);
                while(TS_State.touchDetected == 1)
                    {
                    ts.GetState(&TS_State);
                    }
                lcd.Clear(LCD_COLOR_BLACK);                
                                    
                // goto ReStart;
                }
            }
      }
}



void DisplayBigNumber(uint8_t Numero)
{
    uint8_t v=0;
    uint8_t mv=0;
    
    if (Numero >= 100)
    {
        draw1(200, 200, LCD_YELLOW); // Display 1 pos. x=200 y=200
        v = Numero - 100;
        v = (Numero - 100) / 10;    // Display second number pos.x=250 y=200
        mv = v;
        VisNumber(250, 200, LCD_YELLOW, v, LCD_COLOR_BLACK);
        

        v = (Numero - 100) - (mv * 10); // Display third number pos.300 y=200
        VisNumber(300, 200, LCD_YELLOW, v, LCD_COLOR_BLACK);
    }
    else // Number < 100
    {
        // Clear 3Â° cifra
        FillBox(LCD_COLOR_BLACK, 200, 200, 40, 70);
        
        if (Numero >= 10)
        {
            v = Numero / 10;
            mv = v;
            VisNumber(250, 200, LCD_YELLOW, v, LCD_COLOR_BLACK);    // Vis. 2Â° cifra
            
            v = Numero - (mv * 10);
            VisNumber(300, 200, LCD_YELLOW, v, LCD_COLOR_BLACK);    // Vis. 3Â° cifra
        } 
        else 
        {
            // Clear 2Â° cifra
            FillBox(LCD_COLOR_BLACK, 250, 200, 40, 70);
            VisNumber(300, 200, LCD_YELLOW, Numero, LCD_COLOR_BLACK);    // Vis. 3Â° cifra
        }
    }    
      
}

void VisNumber(int x, int y, uint32_t color, uint8_t v, uint32_t colorBackground)
{
    // Clear Position
    FillBox(colorBackground, x, y, 40, 70);

    switch ( v ) 
    {
        case 1:
            draw1(x, y, color); // Display 1
            break;
        case 2:
            draw2(x, y, color); // Display 2
            break;   
        case 3:
            draw3(x, y, color); // Display 3
            break;   
        case 4:
            draw4(x, y, color); // Display 4
            break;   
        case 5:
            draw5(x, y, color); // Display 5
            break;                                       
        case 6:
            draw6(x, y, color); // Display 6
            break;
        case 7:
            draw7(x, y, color); // Display 7
            break;
        case 8:
            draw8(x, y, color); // Display 8
            break;
        case 9:
            draw9(x, y, color); // Display 9
            break;
        case 0:
            draw0(x, y, color); // Display 0
            break;                                                                                                                                                                                                                                                                                   
        default:
            // Code
            break;                
    }
}   

void Logo(void)
{
    lcd.SetFont(&Font16);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)" By: www.emcu.it", LEFT_MODE);
    lcd.SetFont(&Font24);
}

// void FillBox(string color, int x, int y, int larg, int alt)
void FillBox(uint32_t color, int x, int y, int larg, int alt)
{
    // Draw the RED box that indicate the area to touch for start Timer
    // lcd.SetTextColor(LCD_COLOR_RED);
    lcd.SetTextColor(color);
    lcd.FillRect(x, y, larg, alt);
}

void draw1(int x, int y, uint32_t color)
{     
    FillBox(color, x+20, y, 10, 70);
    FillBox(color, x+10, y+60, 30, 10); // ***
    FillBox(color, x+10, y+10, 10, 10);
    FillBox(color, x, y+20, 10, 10);
}

void draw2(int x, int y, uint32_t color)
{    
    FillBox(color, x,    y,    40, 10);
    FillBox(color, x+30, y+10, 10, 20);
    FillBox(color, x+10, y+30, 20, 10);
    FillBox(color, x,    y+40, 10, 20);
    FillBox(color, x,    y+60, 40, 10);    
}

void draw3(int x, int y, uint32_t color)
{    
    FillBox(color, x,    y,    40, 10);
    FillBox(color, x+30, y+10, 10, 60);
    FillBox(color, x+10, y+30, 30, 10);
    FillBox(color, x,    y+60, 40, 10);    
}

void draw4(int x, int y, uint32_t color)
{  
    FillBox(color, x,    y,    10, 60);
    FillBox(color, x,    y+50, 40, 10);
    FillBox(color, x+20, y+40, 10, 30);
}

void draw5(int x, int y, uint32_t color)
{  
    FillBox(color, x,    y,    40, 10);
    FillBox(color, x,    y,    10, 40);
    FillBox(color, x,    y+30, 40, 10);
    FillBox(color, x+30, y+30, 10, 40);
    FillBox(color, x,    y+60, 40, 10);
}

void draw6(int x, int y, uint32_t color)
{
    FillBox(color, x,    y,    40, 10);
    FillBox(color, x,    y,    10, 70);
    FillBox(color, x,    y+30, 40, 10);
    FillBox(color, x+30, y+30, 10, 40);
    FillBox(color, x,    y+60, 40, 10);
}

void draw7(int x, int y, uint32_t color)
{  
    FillBox(color, x,    y,    30, 10);
    FillBox(color, x+20, y,    10, 70);
    FillBox(color, x+10, y+30, 30, 10);
}

void draw8(int x, int y, uint32_t color)
{  
    FillBox(color, x,    y,    40, 10);
    FillBox(color, x,    y,    10, 70);
    FillBox(color, x+30,  y,    10, 70);
    FillBox(color, x,    y+30, 40, 10);
    FillBox(color, x+30, y+30, 10, 40);
    FillBox(color, x,    y+60, 40, 10);
}

void draw9(int x, int y, uint32_t color)
{  
    FillBox(color, x,    y,    40, 10);
    FillBox(color, x,    y,    10, 40);
    FillBox(color, x,    y+30, 40, 10);
    FillBox(color, x+30, y+30, 10, 40);
    FillBox(color, x,    y+60, 40, 10);
    FillBox(color, x+30, y,    10, 30);
}

void draw0(int x, int y, uint32_t color)
{  
    FillBox(color, x,    y,    40, 10);
    FillBox(color, x,    y,    10, 70);
    FillBox(color, x+30, y,    10, 70);
    FillBox(color, x,    y+60, 40, 10);
}
