
/**

    NUCLEO-F334R8 
    DS18B20 

By:       www.emcu.it
Date:     Dec.2015
Version:  1.0
Name:     F334-DS18B20
NOTE:     For more info see here: http://www.emcu.it/NUCLEOevaBoards/mBed/QSG-Mbed-Library.pdf

THE SOFTWARE AND HARDWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
FITNESS FOR A PARTICULAR PURPOSE AND NON INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS 
OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

UART Configuration (It is necessary for see the results, we suggest to use TeraTerm on PC)  
    Baud Rate:    9600 
    Data Bit:     8
    Parity:       NONE
    Stop Bit:     1
    Flow Control: NONE
    
This SW is ready to use on the NUCLEO-F334R8.
Connect to the NUCLEO-F334R8 the DS18B20 sensor (see the schematic below).
The temperature sampling time is 1 sec.

 DS18B20 front view
    __________
   |          |
   |    DS    |
   |   18B20  |   
   |          |
   |__________|
     |   |   |
     1   2   3
    GND  DQ VCC (3V3)
     |   |   |______________ to VCC (3.3V on the NUCLEO-F334R8)  
     |   |  _|_
     |   |  | |
     |   |  | | 4K7
     |   |  | |
     |   |  -|-
     |   |___|______________ to A1 (on the NUCLEO-F334R8) 
     |
     |
     |______________________ to GND (on the NUCLEO-F334R8)   

This SW is just for only one DS18B20
This SW is a derivative of:: https://developer.mbed.org/users/Sissors/code/DS1820_HelloWorld/
On the: https://developer.mbed.org/users/Sissors/code/DS1820_HelloWorld/ there is a multi sensor (DS18B20) example.

*/

#define DATA_PIN        A1

#include "mbed.h"
#include "DS1820.h"

// Define the PC serial Port
Serial pc(SERIAL_TX, SERIAL_RX);
 
DS1820 probe(DATA_PIN);


int main() 
{
    pc.printf("\n\r\n\rBy: www.emcu.it - simple temperature measurement using the DS18B20\n\r");
    while(1) 
    {
        probe.convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        pc.printf("The temperature is %3.3f Celsius\r\n", probe.temperature());
        wait(1);
    }
}
