#include "mbed.h"

/*

By:         www.emcu.eu
Date:       April 2018
Components: NUCLEO-L011K4 + PANASONIC PIR EKMC1603111
Connections:

PIR VCC     ->  PB_4
PIR Signal  ->  PB_5
PIR GND     ->  PA_11

Buzzer Vcc  ->  PA_9
Buzzer GND  ->  GND of NUCLEO-L011K4

ATTENTION:
For use the NUCLEO-L011K4 with an external power supply, you must do a tin soldering on JP1.
See the NUCLEO-L011K4 datasheet at pg.11
http://www.st.com/content/ccc/resource/technical/document/user_manual/e3/0e/88/05/e8/74/43/a0/DM00231744.pdf/files/DM00231744.pdf/jcr:content/translations/en.DM00231744.pdf

NUCLEO-L011K4 is available from here:
*** http://www.newark.com/stmicroelectronics/nucleo-l011k4/dev-board-nucleo-32-mcu/dp/81Y3973?ost=NUCLEO-L011K4&ddkey=http%3Aen-US%2FElement14_US%2Fsearch
*** https://www.mouser.it/ProductDetail/STMicroelectronics/NUCLEO-L011K4?qs=%2fha2pyFaduhQJSbhHAGqiYkL%252bo2vgvfhlGVOMPt1G42J4HVOM%2fj23Q%3d%3d

PANASONIC PIR EKMC1603111 is available from here:
*** http://www.newark.com/panasonic-electric-works/ekmc1603111/pir-motion-sensor-digital-3vdc/dp/26T3945
*** https://www.mouser.it/ProductDetail/Panasonic/EKMC1603111/?qs=sGAEpiMZZMvhQj7WZhFIAJaM7IUEh%252bHgM6uLDBL6vt0=&gclid=Cj0KCQjwhoLWBRD9ARIsADIRaxR7KH6LCSsPG5aDS1dEvlALL-ijmg-nd1XuzC_C1-15QGecG8rKbckaAn7AEALw_wcB


*/

DigitalOut myled(LED1);
DigitalOut Buzzer(PA_9);   // Drive Buzzer

// Drive PIR
DigitalOut PIU(PB_4);
DigitalOut GND(PA_11);
DigitalIn  ReadPIR(PB_5);   // READ PIR status



uint8_t n=0;

int main() 
{
    Buzzer = 0;
    myled = 0;
                
    // Configure PIR SIGNAL, GND and VCC
    ReadPIR.mode(PullDown);    
    GND=0;
    wait(0.5);
    PIU=1;
    wait(0.5);
    
    // Waiting PIR stabilization
    for (n=0; n<15; n++)
    {
        myled = !myled;
        wait(1);
    }
    myled = 0;
    
    while(1) 
    {
        // Check PIR status
        if (ReadPIR == 1) // PIR out at 1 == was detect a movement
        {
            for (n=0; n<20; n++)
            {
                Buzzer = !Buzzer;
                myled = !myled;
                wait(0.1); // 100 ms
            }
        }
        else // No movement
        {
            Buzzer = 0;
            myled = 0;
        }
    }
}
