/*


 By: www.emcu.eu
 Date: December 2017
 Simple test for: How to use the Adafruit Motor Shield on STM32 NUCLEO
                  the explanations are here:
                  http://www.emcu.eu/how-to-use-the-adafruit-motor-shield-on-stm32-nucleo/
 UART Configuration (It is necessary for see the results, we suggest to use TeraTerm on PC)  
    Baud Rate:    9600 
    Data Bit:     8
    Parity:       NONE
    Stop Bit:     1
    Flow Control: NONE

 ATTENTION
 THE SOFTWARE AND HARDWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 FITNESS FOR A PARTICULAR PURPOSE AND NON INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS 
 OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
*/


#include "mbed.h"

Serial pc(USBTX,USBRX);
DigitalOut LED(LED1);

DigitalOut clockpin(PB_5);  // SCHP or SCK - PB_5
DigitalOut latchpin(PA_6);  // STCP or RCK - PA_6
DigitalOut OE(PA_8);        // OE or G
DigitalOut datapin(PA_9);   // DS or SER - PA_9

DigitalIn PULS(USER_BUTTON);

void PressBB(void);
void WaitSerialChar(void);

int n = 0;


int main() {
    
const int number[10][8]= 
{//  Q7 Q6 Q5 Q4 Q3 Q2 Q1 Q0    Line
   { 1, 0, 1, 0, 1, 0, 1, 0}, // 0     
   { 0, 1, 0, 1, 0, 1, 0, 1}, // 1      
   { 1, 0, 1, 1, 0, 1, 1, 0}, // 2
   { 1, 0, 0, 1, 1, 1, 1, 1}, // 3
   { 1, 1, 0, 0, 1, 1, 0, 0}, // 4
   { 1, 1, 0, 1, 1, 0, 1, 1}, // 5
   { 1, 1, 1, 1, 1, 0, 0, 0}, // 6
   { 0, 0, 0, 0, 1, 1, 1, 1}, // 7
   { 1, 1, 1, 1, 1, 1, 1, 0}, // 8
   { 1, 1, 0, 0, 1, 1, 1, 1}  // 9
};

pc.printf("\n\r\n\r\n\r The explanations are here:\n\r");
pc.printf(" http://www.emcu.eu/how-to-use-the-adafruit-motor-shield-on-stm32-nucleo/ \n\r");
    while(1) 
    {   
        OE = 0;
        
        pc.printf("\n\r\n\r START... \n\r\n\r");
        pc.printf("     74HC595 \n\r");
        pc.printf("     _______ \n\r"); 
        pc.printf(" Q1 1  |_|  16 VCC \n\r"); 
        pc.printf(" Q2 2       15 Q0  \n\r"); 
        pc.printf(" Q3 3       14 DS  \n\r"); 
        pc.printf(" Q4 4       13 /OE \n\r");
        pc.printf(" Q5 5       12 STCP\n\r");
        pc.printf(" Q6 6       11 SHCP\n\r");
        pc.printf(" Q7 7       10 /MR \n\r");
        pc.printf("GND 8_______ 9 Q7S \n\r\n\r");
        
        for(int j=0;j<=1;j++) // 9
        {  
            latchpin=0;
            
            pc.printf(" Q7 Q6 Q5 Q4 Q3 Q2 Q1 Q0\n\r");
            for(int i=0;i<=7;i++)  
            {
                pc.printf(" %d ", number[j][i]);
                datapin=number[j][i];
                wait_ms(1);
                clockpin=1;
                wait_ms(1);
                clockpin=0;
                wait_ms(1);
            }

            latchpin=1;  
            wait_ms(5);
            latchpin=0;
            wait_ms(1);
            OE = 1;
            wait_ms(1);
            OE = 0;
            wait_ms(1);
                                  
            WaitSerialChar();
            pc.printf(" \n\r");
               
         }
        pc.printf(" END.... \n\r");
        WaitSerialChar();
        
    }
}


void WaitSerialChar(void)
{
    pc.printf(" Press a key on PC to continue\n\r");
    while (pc.readable() != 1);
    pc.getc();
}

    
void PressBB(void)
{
    pc.printf("Press Blue Button on PC to continue\n\r");
    while (PULS != 0)  // Button not pressed
    {
        LED = !LED;
        wait(0.1);
    }
}