/*
 
  RX for remote Thermostat
    
  By: www.emcu.eu
  Date: 04-January-2017
 
  NUCLEO-L152RE and AUREL RTX-MID-3V (433.92 MHz - mod. ASK - 3Vcc)
 
  AUREL RTX-MID-3V 
  Italian AUREL manual is here: http://www.aurelwireless.com/wp-content/uploads/manuale-uso/650201033G_mu.pdf
  English AUREL manual is here: http://www.aurelwireless.com/en/radiomodem-data-transceivers/ 
  https://www.futurashop.it/index.php?route=product/product&filter_name=RTX-MID-3V&product_id=2788
 
  CONNECTIONS from AUREL RTX-MID-3V to NUCLEO L152RE
  PIN1    Antenna 17cm
  PIN2    GND
  PIN4    TX connected to TX on NUCLEO L152RE
  PIN5    Tx/Rx connected to PA_10 on NUCLEO L152RE 
  PIN6    ENABLE connected to PB_3 on NUCLEO L152RE
  PIN7    GND
  PIN8    Analog Out not connected
  PIN9    RX connected to RX on NUCLEO L152RE
  PIN10   VCC connected to 3,3V on NUCLEO L152RE
  
  NOTE: between GND and VCC put a capacitor of 0,1uF and a second capacitor 
  of 10uF
 
    
    ********** IMPORTANT IMPORTANT IMPORTANT IMPORTANT **********
    
    This project use the USART for this reason you must do the below 
    modifications on NUCLEO-L152RE, more info are here:
    http://www.emcu.it/NUCLEOevaBoards/U2andL152/U2andL152.html#USART2_for_communication_with_shield_or
    
    Put a jumper on SB62 and on SB63
    Remove a 0 ohm resistor from SB13 and SB14
    
    ATTENTION:
    After this modifications, you lost the possibility to use the virtual comm 
    to connect the NUCLEO to the PC .
 
    *************************************************************  
  
    
    ********** EXPLANATIONS:
    
    Build two boards one with RX software and another with TX software. 
    When you press Blue button (and hold it)
    on the board_TX, the green LED must turn ON, the same 
    on the board_RX the green LED must turn ON.
    If you release the Blue button (on the board_TX) the green LED must go OFF 
    on both on the boards.
    
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 
 
 */
 
 
#include "mbed.h"
 
Serial pc(SERIAL_TX, SERIAL_RX);    // tx, rx
DigitalOut RTX_DIR(PA_10);          // 1 == TX  0 == RX
DigitalOut RTX_Enable(PB_3);        // 1 == RTX enable  0 == RTX disable
 
DigitalOut myled(LED1);                 // This LED is on NUCLEO-L152RE
DigitalIn BlueButton(USER_BUTTON);      // This is Blue-Button and is on NUCLEO-L153RE
 
#define Pressed 0
#define NotPressed 1
#define Enable 1
#define Disable 0
#define ACK 2
#define OK 1
#define FAIL 0
#define Received 0
#define NotReceived 1
 
#define ON  1
#define OFF 0
#define TX 1
#define RX 0

#define Baud 1200           // 9600
#define DlyForEndTX 220     // 220
#define MaxReTX 40
#define DebTime 100         // Debounce time
 
int Car='\0';
int RisultatoRX=FAIL;
int MemBlueButton=10;
int MemOkFail=FAIL;
int MemOK=FAIL;
int MemOFF=NotReceived;
int MemON=NotReceived;

int MemBB = NotPressed;
 
 
int TestRX_Data(void);
void RTX_StartUp(void);
void RTX_PowerDown(void);
void RTX_PowerON(void);
void RTX_TX(void);
void RTX_RX(void);
 
int CarStr[3];
int PuntCar = 0;

void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    Car = pc.getc();
    if (Car == '#' & PuntCar == 0)
        {               
        PuntCar = 0;
        CarStr[PuntCar] = Car;
        PuntCar++;
        }        
    else if (PuntCar > 0 & PuntCar < 3)
        {          
        CarStr[PuntCar] = Car;
        PuntCar++;
        }
}


//
// MAIN *****************************************************************
//
int main()
{
    int n=0;
    
    pc.baud(Baud); 
    pc.attach(&callback, pc.RxIrq); // It is for reading under Interrupt the 
                                    // RX from USART
    
    // Start Up of the RTX-MID and put it in RX mode
    RTX_StartUp();
    
    MemBB = Pressed;
    MemOFF = NotReceived;
    MemON = NotReceived;
        
    while (1)
    {
        
        // RX mode ************************************************************
        // Decode Message
        // 1==OK==ON  2==ACK==OFF
        RisultatoRX = TestRX_Data();
        if (RisultatoRX == OK)  // OK==ON
            {
            myled = ON;
            // Send ON
            // and test if the Message is arrived  
            n=0;
            wait_ms(10);
            while (TestRX_Data() != OK)                      
                {    
                RTX_TX();           // RTX-MID on TX mode        
                // Send Message
                pc.printf("#1@");   // Send Command
                wait_ms(DlyForEndTX); 
                RTX_RX();           // RTX-MID on RX mode  
                n++;
                if (n > MaxReTX)
                    break;                               
                }             
            MemOFF = NotReceived;
            MemON = Received;                
            RTX_RX();   // RTX-MID on RX mod
            }
            
        if (RisultatoRX == ACK) // ACK==OFF
            { 
            myled = OFF;
            // Send OFF
            // and test if the Message is arrived  
            n=0;     
            wait_ms(10);     
            while (TestRX_Data() != ACK)
                {    
                RTX_TX();           // RTX-MID on TX mode        
                // Send Message
                pc.printf("#2@");   // Send Command OFF
                wait_ms(DlyForEndTX); 
                RTX_RX();           // RTX-MID on RX mode   
                n++;
                if (n > MaxReTX)
                    break;                            
                } 
            MemOFF = Received;
            MemON = NotReceived;
            RTX_RX();   // RTX-MID on RX mod
            }   
        // END RX mode ********************************************************              
    }
}
 
//
// END MAIN *************************************************************
//
 
 
//
// Decode Message
//
// REMEMBER: 
// before to use this function must put in RX mode the RTX
//
int TestRX_Data(void)
    {
    int OkFail=0; // 1==OK==ON  2==ACK==OFF
    
    if (CarStr[0]=='#' & CarStr[1]=='1' & CarStr[2]=='@')   
        OkFail=1; // OK==ON               
    else if (CarStr[0]=='#' & CarStr[1]=='2' & CarStr[2]=='@') 
        OkFail=2; // ACK==OFF
    else;
         
    if (PuntCar >= 3) // Reset the CarStr & PuntCar
        { 
        CarStr[0] = '0';
        CarStr[1] = '1';
        CarStr[2] = '2';
        PuntCar = 0;                  
        }
        
    return OkFail;         
    }
    
void RTX_StartUp(void)
    {
    RTX_Enable = Disable;
    wait_ms(10);        
    RTX_Enable = Enable;
    wait_ms(1); 
    RTX_DIR = TX;     // RTX-MID in TX mode
    wait_ms(1);       // Wait the stabilizzation of the transceiver
    RTX_Enable = Disable;
    wait_ms(10);        
    RTX_Enable = Enable;
    wait_ms(1);                                            
    RTX_DIR = RX;     // RTX-MID in RX mode
    wait_ms(1);       // Wait the stabilizzation of the transceiver             
    RTX_Enable = Disable;
    wait_ms(1);
    RTX_Enable = Enable;
    wait_ms(1);         
    }
 
void RTX_PowerDown(void)
    {
    RTX_Enable = Disable;
    wait_ms(10);
    }
    
void RTX_PowerON(void)
    {
    RTX_Enable = Disable;
    wait_ms(1);
    }    
    
void RTX_TX(void)
    {
    // RTX_Enable = Disable;
    // wait_ms(10); 
    // RTX_Enable = Enable;
    // wait_ms(1);        
    RTX_DIR = TX;     // RTX-MID in TX mode
    wait_us(400);     // Wait the stabilizzation of the transceiver     
    }        
 
void RTX_RX(void)
    {
    // RTX_Enable = Disable;
    // wait_ms(10); 
    // RTX_Enable = Enable;
    // wait_ms(1);  
    // RTX_DIR = TX;     // RTX-MID in TX mode
    // wait_ms(1);       // Wait the stabilizzation of the transceiver
    RTX_DIR = RX;     // RTX-MID in RX mode
    wait_us(40);
    RTX_Enable = Disable;
    wait_us(20);       
    RTX_Enable = Enable; 
    wait_us(200);                                                             
    }
 
 