#include "mbed.h"
#include "EthernetInterface.h"
#include "MbedJSONValue.h"

MbedJSONValue parser;
EthernetInterface eth;
TCPSocketConnection sock;

int main()
{
    int http_tx_msg_sz=800;
    char http_tx_msg[http_tx_msg_sz];
    int http_rx_msg_sz=500;
    char http_rx_msg[http_rx_msg_sz];
    int returnCode = 0;

    // Enter a MAC address for your controller below.
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02};

    printf("initializing Ethernet\r\n");
    // initializing MAC address
    eth.init(mac_addr, "192.168.0.34", "255.255.255.0", "192.168.0.1");

    // Check Ethenret Link
    if(eth.link() == true)   printf("- Ethernet PHY Link-Done \r\n");
    else printf("- Ethernet PHY Link- Fail\r\n");

    // Start Ethernet connecting: Trying to get an IP address using DHCP
    if (eth.connect()<0)    printf("Fail - Ethernet Connecing");

    // Print your local IP address:
    printf("IP=%s\n\r",eth.getIPAddress());
    printf("MASK=%s\n\r",eth.getNetworkMask());
    printf("GW=%s\n\r",eth.getGateway());

    while(1) {
        sock.connect("192.168.0.223", 8000);

        snprintf(http_tx_msg, http_tx_msg_sz,  "GET / HTTP/1.1\r\nHost: 192.168.0.223:8000\r\nUser-Agent: WIZwiki-W7500ECO\r\nConection: close\r\n\r\n");
        sock.send_all(http_tx_msg, http_tx_msg_sz-1);

        while ( (returnCode = sock.receive(http_rx_msg, http_rx_msg_sz-1)) > 0) {
            http_rx_msg[returnCode] = '\0';
            printf("Received %d chars from server:\n\r%s\n", returnCode, http_rx_msg);
        }

        sock.close();

        parse(parser, http_rx_msg);
        printf("name =%s\r\n" , parser["name"].get<string>().c_str());
        printf("age =%d\r\n" , parser["age"].get<int>());
        printf("gender =%s\r\n" , parser["gender"].get<string>().c_str());

        wait(10);
    }

}
