#include <stdio.h>
#include <string.h>
#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#define INIT 0x1
#define SOCKET 0x2
#define CLIENTE 0x4
#define WEB 0x8


#if defined(TARGET_LPC1768)
SPI spi(p5, p6, p7); // mosi, miso, sclk
EthernetInterface eth(&spi, p8, p11); // spi, cs, reset
#endif
Serial pc(USBTX , USBRX);
TCPSocketServer server; 
TCPSocketConnection client;   

int aceptado=1;
int ret;
char control;
char dummy;
int ready;
char paq_en[64];
char a[]={"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nPragma: no-cache\r\n\r\n"};
char b[]={"<html>\r\n<body>\r\n"};
char c[]={"<title>WebServer WIZ550io</title>\r\n"};
char d[]={"<h2>RTOS Webserver with WIZ550io </h2>\r\n"};
char e[]={"<br /><hr>\r\n"};
char f[]={"<FONT FACE=\"Arial\" SIZE=\"2\" COLOR=\"FF0000\">"};
char g[]={"</html>"};

const char * IP_Addr    = "192.168.77.34";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "192.168.77.1";


void f_ethernet_init(void);



//TASK INICIALIZAR ETHERNET//////////////////////////////////////
void TASK_InitEthernet(void const *argument)
{
    while(true)
    {
        //pc.printf("TASK_InitEthernet\n");
        Thread::signal_wait(INIT);
        f_ethernet_init(); 
        control=SOCKET; 
    }
}
/////////////////////////////////////////////////////////////////

//TASK SOCKET////////////////////////////////////////////////////
void TASK_Socket(void const *argument)
{
    while(true)
    {
        //pc.printf("TASK_Socket\n");
        Thread::signal_wait(SOCKET);
        control=0;
        //TCPSocketServer server;          //crea servidor
        server.bind(80);   //Puerto
        server.listen();                 //Escucha por clientes
        //pc.printf("\nEsperando conexion con cliente...\n");
        //pc.printf("\nWaiting for connection to client...\n");

        //TCPSocketConnection client;      //Realiza la conexion con clientes
        aceptado=server.accept(client);
        client.set_blocking(false, 1500); //timeout after (1.5)s
        //pc.printf("Connection from: %s\n", client.get_address());

        if(!aceptado)
        {
            //pc.printf("Conectado");
            //pc.printf("Connecting");
            control=CLIENTE;
        }
        else
        {
            //pc.printf("Fallo la conexion con cliente");
            //pc.printf("Fail the connection with client");
            control=SOCKET;
        }
    }
}

////////////////////////////////////////////////////////////////

///TASK_CLIENTE/////////////////////////////////////////////////
void TASK_Cliente(void const *argument)
{
    while(true)
    {
        //pc.printf("TASK_Cliente\n");
        Thread::signal_wait(CLIENTE);
        client.send(a,sizeof(a));
        client.send(b,sizeof(b));
        client.send(c,sizeof(c));
        client.send(d,sizeof(d));
        client.send(e,sizeof(e));
        client.send(f,sizeof(f));
        control=WEB;
        ready=1;
    }
}
/////////////////////////////////////////////////////////////////


///TASK_WEB//////////////////////////////////////////////////////
void TASK_Web(void const *argument)
{
    while(true)
    {
        //pc.printf("TASK_Web\n");
        Thread::signal_wait(WEB);  
        client.send(paq_en,sizeof(paq_en));  
        client.send(g,sizeof(g));
        control=SOCKET;
        client.close();
    } 
}
/////////////////////////////////////////////////////////////////

int main()
{
#if defined(TARGET_LPC1768)
    spi.frequency(12500000);     
#endif    
    Thread thread1(TASK_InitEthernet);
    Thread thread2(TASK_Socket);
    Thread thread3(TASK_Cliente);
    Thread thread4(TASK_Web);

    thread1.signal_set(INIT);

    while(1)
    {
        if(control==SOCKET)
            thread2.signal_set(SOCKET);
        wait(0.5);

        if(control==CLIENTE)
        {
            thread3.signal_set(CLIENTE);
        }

        if(control==WEB)
        {
            dummy++;
            sprintf(paq_en,"<FONT><BR>Valor=%d</FONT>",dummy);
            thread4.signal_set(WEB);
            if(dummy == 64)
                dummy =0;
        }
    }

}



void f_ethernet_init()
{
    uint8_t mac[]={0x00,0x08,0xDC,0x1C,0xAA,0xCA};
    // mbed_mac_address((char *)mac); 
    //pc.printf("\tIniciando Servidor Ethernet...\n\r");
    pc.printf("\tInitialize Server Ethernet...\n\r");
    wait(1);
    ret = eth.init(mac, IP_Addr, IP_Subnet, IP_Gateway);
    if(!ret)
    {
        //pc.printf("Inicializado, MAC= %s\n\r",eth.getMACAddress());
        pc.printf("Initialized, MAC= %s\n\r",eth.getMACAddress());
    }    
    else
    {
        //pc.printf("Fallo comunicacion... Reinicie dispositivos...\n\r");    
        pc.printf("Failure Communication ... Restart devices ...\n\r");    
    }
    //pc.printf("Conectando.");
    pc.printf("Connecting.");
    wait(2);
    pc.printf(".");
    wait(2);
    pc.printf(".\n\r");
    wait(1);
    ret = eth.connect();
    if(!ret)
    {
        //pc.printf("Conexion Establecida!\n\n\r");
        pc.printf("Connection Established!\n\n\r");
        wait(1);
        pc.printf("IP=%s\n\rMASK=%s\n\rGW=%s\n\r",eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    }    
    else
    {
        //pc.printf("Fallo conexion... Reinicie dispositivos...\n\r"); 
        pc.printf("Failure Communication ... Restart devices ...\n\r");    
    }
}  

