#include "mbed.h"
#include "EthernetInterface.h"
#include "mbed_rpc.h"
#include "RPCCommand.h"
#include "HTTPServer.h"
#include "Formatter.h"
#include "RequestHandler.h"
#include "RPCType.h"

#define SERVER_PORT 80

char ipaddr_backup[17];
uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02};

HTTPServer create_simple_server()
{    
    HTTPServer srv;
    srv.add_request_handler("DELETE", new DeleteRequestHandler());
    srv.add_request_handler("GET", new GetRequestHandler());
    srv.add_request_handler("PUT", new PutRequestHandler());
    return srv;
}

HTTPServer create_interactive_server()
{
    HTTPServer srv(new InteractiveHTMLFormatter());
    srv.add_request_handler("GET", new ComplexRequestHandler());
    return srv;
}

int main(void)
{
    RPCType::instance().register_types();    
 /* //for LPC1768
    SPI spi(p5, p6, p7); // mosi, miso, sclk
    spi.frequency(12500000);     
    EthernetInterface eth(&spi, p8, p11); // spi, cs, reset
*/    
    SPI spi(D11, D12, D13); // mosi, miso, sclk
    //spi.frequency(12500000);     
    EthernetInterface eth(&spi, D10, D9); // spi, cs, reset

    //EthernetInterface eth;
    //if(eth.init())
//    int ret = eth.init("192.168.77.34", "255.255.255.0", "192.168.77.1");    
    int ret = eth.init(mac_addr, "192.168.77.34", "255.255.255.0", "192.168.77.1");    
    if(ret)
    {
        printf("Error while initializing the ethernet interface.\n");
        return -1;
    }
    if(eth.connect())
    {
        printf("Error while starting the ethernet interface.\n");
        return -1;
    }
    
    printf("IP Address is %s\n", eth.getIPAddress());
    strcpy(ipaddr_backup,eth.getIPAddress());
    HTTPServer srv = create_interactive_server();

    if(!srv.init(SERVER_PORT))
    {
        eth.disconnect();
        return -1;
    }

    srv.run();

    return 0;
}

