#include "mbed.h"
#include "DHT.h"
#include "EthernetInterface.h"

/*
 *Input Pins, Misc
 */
DHT sensor(D4, DHT11);
DigitalIn  triggerPin(D3);

EthernetInterface eth;
TCPSocketConnection sock;


/*
 * if you don't want to use DNS (and reduce your sketch size)
 * use the numeric IP instead of the name for the server:
 * IPAddress server(54,86,132,254);  // numeric IP for data.sparkfun.com
 */
//char server[] = "data.sparkfun.com";    // name address for data.spark

/*
 * Phant Stuffs
 */
char publicKey[] = "NJxQ73DlZWTaJNyon1bL";//"insert_your_publicKey"
char privateKey[] = "5dEXwN0qJPI72PjkG8gx";//"insert_your_privateKey";
uint8_t NUM_FIELDS = 2;
char fieldNames1[] = "hum";
char fieldNames2[] = "temp";

void post_data(void);

int main() 
{
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;
    float val, val_lightPin, val_tempPin;
    int http_cmd_sz=800;
    char http_cmd[http_cmd_sz];
    int buffer_sz=300;  
    char buffer[buffer_sz];  
    int returnCode = 0;
    // Enter a MAC address for your controller below.
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02};     

    printf("initializing Ethernet\r\n");
    // initializing MAC address
    eth.init(mac_addr);
    
    // Check Ethenret Link
    if(eth.link() == true)   printf("- Ethernet PHY Link-Done \r\n");
    else printf("- Ethernet PHY Link- Fail\r\n");
    
    // Start Ethernet connecting: Trying to get an IP address using DHCP
    if (eth.connect()<0)    printf("Fail - Ethernet Connecing");
    
    // Print your local IP address:
    printf("IP=%s\n\r",eth.getIPAddress());
    printf("MASK=%s\n\r",eth.getNetworkMask());
    printf("GW=%s\n\r",eth.getGateway());

    while(1)
    {
        if(triggerPin ==0)
        {
            sensor.readData();
            c   = sensor.ReadTemperature(CELCIUS);
            h   = sensor.ReadHumidity();
           printf("Temperature in Celcius: %4.2f", c);
           printf("Humidity is %4.2f\n", h, dp, dpf);
          
          sock.connect("data.sparkfun.com", 80);
    
          snprintf(http_cmd, http_cmd_sz,  "GET /input/%s?private_key=%s&%s=%2.2f&%s=%3.3f HTTP/1.1\r\nHost: data.sparkfun.com\r\nConection: close\r\n\r\n", 
                                            publicKey, privateKey, fieldNames1, h, fieldNames2, c);
          sock.send_all(http_cmd, http_cmd_sz-1);
    
          while ( (returnCode = sock.receive(buffer, buffer_sz-1)) > 0)
          {
              buffer[returnCode] = '\0';
              printf("Received %d chars from server:\n\r%s\n", returnCode, buffer);
          }
  
          sock.close();         
        }
        
        wait(2);
    } 
}



