#include "mbed.h"
#include "EthernetInterface.h"

DigitalOut myled(LED1);

// Initialize the Ethernet client library
EthernetInterface eth;

int main() {
    // Enter a MAC address for your controller below.
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02}; 
    
    // initializing MAC address
    eth.init(mac_addr);

    // Check Ethenret Link
    if(eth.link() == true)
        printf("- Ethernet PHY Link-Done \r\n");
    else
        printf("- Ethernet PHY Link- Fail\r\n");

    // Start Ethernet connecting
    if ( eth.connect() < 0 )
        printf("Fail - Ethernet Connecing");
    else
    {
        // Print your local IP address:
        printf("IP=%s\n\r",eth.getIPAddress());
        printf("MASK=%s\n\r",eth.getNetworkMask());
        printf("GW=%s\n\r",eth.getGateway());
    }        

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
