#include "mbed.h"
#include "EthernetInterface.h"

#if defined(TARGET_LPC1114)
    SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
    EthernetInterface eth(&spi, dp25, dp26); // spi, cs, reset
    AnalogIn pot1(dp13);
#else
    EthernetInterface eth;
    AnalogIn pot1(p19);
    AnalogIn pot2(p20);
#endif 

#if defined(TARGET_LPC1768)
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4); 
#endif

TCPSocketConnection sock;
 
int main() 
{
    char *MODEL = "mbed";
    char *SERIAL_NUM = "nlr__embeddist_gmail_com___343881"; 
    float DEADBAND = 0.015;
    
    char* ip;
    
    int http_cmd_sz=800;
    char http_cmd[http_cmd_sz];
    int buffer_sz=300;  
    char buffer[buffer_sz];  
    int returnCode = 0;
    
#if defined(TARGET_LPC1768)    
    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;
#endif
    
    printf("initializing Ethernet\r\n");
    returnCode = eth.init(); //Use DHCP
 
    if ( returnCode == 0 )
    {
        printf(" - Ethernet ready\r\n");
#if defined(TARGET_LPC1768)    
        led1 = returnCode;
#endif        
    }
    else
    {
        printf(" - Could not initialize Ethernet - ending\r\n");
        return 0;
    }
    
    printf("Ethernet.connecting \r\n");
    returnCode = eth.connect();
    printf(" - connecting returned %d \r\n", returnCode);
#if defined(TARGET_LPC1768)    
    led2 = returnCode != -1 ? 0: 1;
#endif    
    printf("Trying to get IP address..\r\n");
    ip = eth.getIPAddress();
#if defined(TARGET_LPC1768)        
    led3 = strlen(ip)<4 ? 1: 0;
#endif    
    printf("  -  IP address:%s\r\n", ip);
    
    float oil_level = 0.0;
    float oil_level2= 0.0;
    float oldPotVal = -2.0;
    float oldPotVal2 = -2.0;
    
    while(1) {
    
        oil_level = pot1.read();
#if defined(TARGET_LPC1768)            
        oil_level2=pot2.read();
#endif        
        //if ( abs(oil_level - oldPotVal) < DEADBAND && abs(oil_level2 - oldPotVal2) < DEADBAND) //LPC1768
        if ( abs(oil_level - oldPotVal) < DEADBAND) //LPC1114
        {
            continue;   
        }
        else
        {
            //led4 = 1;
            oldPotVal = oil_level;
#if defined(TARGET_LPC1768)            
            oldPotVal2 = oil_level2; 
#endif            
            printf("Sending Value for well1 %.2f\n\r", oil_level);
#if defined(TARGET_LPC1768)                        
            printf("Sending Value for well2 %.2f\n\r", oil_level2);
#endif            
            sock.connect("toolbox-connect.axeda.com", 80);
 
            snprintf(http_cmd, http_cmd_sz,  "POST /ammp/data/1/%s!%s HTTP/1.1\r\nContent-Type: application/json\r\nContent-Length: 65\r\n\r\n{\"data\":[{\"di\":{\"oil_level\":%.2f, \"oil_level2\":%.2f}}]}\r\n\r\n", MODEL, SERIAL_NUM, oil_level, oil_level2);
            sock.send_all(http_cmd, http_cmd_sz-1);
    
            while ( (returnCode = sock.receive(buffer, buffer_sz-1)) > 0)
            {
                buffer[returnCode] = '\0';
                printf("Received %d chars from server:\n\r%s\n", returnCode, buffer);
            }
            //led4 = returnCode;
            sock.close();
        }
 
    }
 
}
