#include "mbed.h"
#include "rtos.h"
#include "C12832_lcd.h"
#include "Arial_9.h"
#include "Small_7.h"
#include "graphics.h" 
#include "MMA7660.h"


DigitalIn fire(p14);
PwmOut spkr(p26);

C12832_LCD lcd;

PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

MMA7660 MMA(p28, p27);

DigitalOut connectionLed(LED1);
PwmOut Zaxis_p(LED2);
PwmOut Zaxis_n(LED3);

Mutex lcd_mutex;

void Axisaccelerometer_thread(void const *args) 
{
   lcd_mutex.lock();
  
      if (MMA.testConnection())
        connectionLed = 1;
        
    while(1) {
        Zaxis_p = MMA.z();
        Zaxis_n = -MMA.z();
        
    lcd_mutex.unlock(); 
    }
   
}

void RGB_thread(void const *args) 
{    
  
r.period(0.001);
    while(1) {

        for(float i = 0.0; i < 1.0 ; i += 0.001) {
            float p = 3 * i;
            r = 1.0 - ((p < 1.0) ? 1.0 - p : (p > 2.0) ? p - 2.0 : 0.0);
            g = 1.0 - ((p < 1.0) ? p : (p > 2.0) ? 0.0 : 2.0 - p);
            b = 1.0 - ((p < 1.0) ? 0.0 : (p > 2.0) ? 3.0 - p : p - 1.0);  ;  
            wait (0.01);
        }
 
   }

}

void ChristmasLCD_thread(void const *args) 
{   

lcd_mutex.lock();

int i,s;
    lcd.cls();
    lcd.set_font((unsigned char*) Arial_9);
    s = 3;
    lcd.print_bm(bitmTree,95,0);  // print chistmas tree
    lcd.copy_to_lcd(); 
    lcd.setmode(XOR);             // XOR - a second print will erase  
    for(i = -15; i < 75; ){     
        lcd.print_bm(bitmSan1,i,2);
        wait(0.5);
        lcd.copy_to_lcd();           // update lcd  
        lcd.print_bm(bitmSan1,i,2);  // erase
        i= i+s;
        lcd.print_bm(bitmSan2,i,2);  // print next
        wait(0.5);
        lcd.copy_to_lcd();           // update lcd   
        lcd.print_bm(bitmSan2,i,2);  // erase
        i= i+s;
        lcd.print_bm(bitmSan3,i,2);  // print next 
        wait(0.5);
        lcd.copy_to_lcd();           // update lcd
        lcd.print_bm(bitmSan3,i,2);  // erase
        i= i+s;
   }
   lcd.print_bm(bitmSan3,i,2);
   lcd.set_auto_up(0);
   for(i=-20; i<5; i++){             // scrolling text
     lcd.locate(5,i);
     lcd.printf("Happy");
     lcd.locate(5,i+12);
     lcd.printf("Christmas");
     lcd.copy_to_lcd();
     lcd.locate(5,i);
     wait(0.2);
     lcd.printf("Happy");
     lcd.locate(5,i+12);
     lcd.printf("Christmas");
     lcd.copy_to_lcd();
     i=i+1;
   }  
   lcd.locate(5,i);
   lcd.printf("Happy");
   lcd.locate(5,i+12);
   lcd.printf("Christmas");
   lcd.copy_to_lcd();
   
   lcd_mutex.unlock();  

}

int main()
{
     Thread thread1(RGB_thread);
     Thread thread2(ChristmasLCD_thread);
     Thread thread3(Axisaccelerometer_thread);
     
     
    while (1) {
        
        for (float i=2000.0; i<10000.0; i+=100) {
            spkr.period(1.0/i);
            spkr=0.5;
            wait(0.1);
        }
        spkr=0.0;
        while(!fire) {}
    }
}
 
