
/************Author embedded nerd**********************/
/*********www.embedded.zettamonk.com*******************/
/**************Free to use Lic************************/
/*************Date 28 Aug 2014***********************/
/* Code Demonstarte most of the feature of application board/
/like LED, Speaker,RGB,Joystick,LCD,POT,Accelomenter,temprature sensor/
/by using component of real time oprating system such as Mutex, Threads/
Signals,Queue and  Memorypool//////////////////////////////////////////*/

/////////////////////////////////////////Header Files//////////////////////
#include "mbed.h"
#include "rtos.h"    // real time os
#include "Small_6.h"  // LCD
#include "Small_7.h"  // LCD
#include "Arial_9.h"   // LCD
#include "stdio.h"     
#include "C12832_lcd.h"   // LCD
#include "LM75B.h"      // temprature 
#include "MMA7660FC.h"  
#include "MMA7660.h"    // Axix
#include <string>
#define SET 1
#define RESET 0 
#define ADDR_MMA7660 0x98  //// I2C SLAVE ADDR MMA7660FC


/****************************Defination and Object Creation*****************************/
C12832_LCD LCD;  // LCD object
BusOut leds(LED1,LED2,LED3,LED4); // Led decration 
AnalogIn Pot1(p19);              // Analog pin name decration 
AnalogIn Pot2(p20);              // Analog pin name decration
BusIn Up(p15);                   //Joy stick
BusIn Down(p12);                 //Joy stick
BusIn Left(p13);                    //Joy stick
BusIn Right(p16);                //Joy stick 
BusOut Reset(p14);              //Joy stick
PwmOut spkr(p26);              //Speaker 
PwmOut r (p23);                //RGB red  
PwmOut g (p24);                //RGB green
PwmOut b (p25);                // RGB blue 
LM75B sensor(p28,p27);          // I2c  
MMA7660FC Acc(p28, p27, ADDR_MMA7660);      //sda, scl, Addr
MMA7660 MMA(p28, p27);
/*****************************************************************************************/
//r.period(0);  

                            //     0      1        2       3       4       5     6        7
const string display_menu[]   = {"     ","LED  ","POT  ","Temp ","Axix ","Spker","RGB ","POT2"}; // aray to display modules on LCD
unsigned char oprate_menu[] =   {0,       0,      0,      0,       0,     0,       0,     0};     // Store Flags for module


typedef struct {
    float    voltage;  
    float    current;   
    uint32_t counter;   
} message_t;
MemoryPool<message_t, 16> mpool;
Queue<message_t, 16> queue;
                                 

//Mutex decleration of LCD
Mutex lcd_mutex;

// Semaphore Declearation of Calcualtion with two slots 
Semaphore calculate(2);
int count= 0,menu = 0;
/*////////////////////// Thread led/////////////////////////
Input:
Output: LED 
 if module flag is set than it will turn led on from 0X00 to 0X0F 
 //////////////////////////////////////////////////////////*/
void led(void const *args)
{
    
    char out =0;
    while(true) {       // thread loop
                 if (oprate_menu[1] == SET)     // Checking flag for module 
                 {
                     leds = out;                 // Turning LEd on   
                     out++;
                     if(out>16) out = 0;         // Reseting count  
                 }
                 else  leds = 0;                // If flag not set than turn of the module 
                 Thread::wait(100);             // Thread wait .1s
                }
               
}  // thread close 

/*////////////////////// Thread menu_sel/////////////////////////
Input: Joustick
Output: Set flag in oprate_menu
By using left right key user in enable to change module and by up
cown key user is able to set module on or off bye pressinf enter key 
 //////////////////////////////////////////////////////////*/
void menu_sel(void const *args)
{
    int k;
    while(true) {       // thread loop
        //LCD.locate(0,5);LCD.printf("                 ");
        
        LCD.set_font((unsigned char*) Small_7);
        if (Left)              // Checking keys 
           {
            count = 0 ;
            menu--;       // manipulating menue number as per key response 
            if(menu<1){ menu = 7;}  //
            lcd_mutex.lock();
            LCD.locate(50,10);
            LCD.printf(" %s",display_menu[menu]);    // displaying menue on LCD
            lcd_mutex.unlock(); 
             wait(1); 
           }           
        if (Right)
           {
            count = 0 ;
            menu++;
            if(menu>7) {menu = 1;}
            
            lcd_mutex.lock();
            LCD.locate(50,10);
            LCD.printf(" %s",display_menu[menu]); 
            lcd_mutex.unlock();
             wait(1); 
           //while(Right); 
           }    
         if(Up) 
                 {
                        count = 1 ;           // Manipulating flag as per selection from user 
                     LCD.set_font((unsigned char*) Small_7);
                         lcd_mutex.lock();
                         LCD.locate(50,20);
                         LCD.printf(" ON "); 
                         lcd_mutex.unlock(); 
                 }
                if(Down)
                 {
                     count = 0;
                      LCD.set_font((unsigned char*) Small_7);
                        lcd_mutex.lock();
                         LCD.locate(50,20);
                         LCD.printf(" OFF"); 
                         lcd_mutex.unlock(); 
                 }                  
        if (Reset)
            {
                     LCD.set_font((unsigned char*) Small_7);
                        lcd_mutex.lock();
                         LCD.locate(50,20);
                         LCD.printf("   "); 
                         lcd_mutex.unlock(); 
               oprate_menu[menu] = count;
               //if menu = 1 thread.signal_set(0x1);
            }    
        
        Thread::wait(10); // wait 0.5s
    }
}


/*////////////////////// Thread spk/////////////////////////
Input: 
Output: Turn on speaker on board 
Turn on PWM on speaker pin for specific period of time 
 //////////////////////////////////////////////////////////*/
void spk(void const *args)
{
   while (1) {
        if (oprate_menu[5] == SET)
        {
                for (float i=2000.0; i<10000.0; i+=500) {
                    spkr.period(1.0/i);
                    spkr=0.5;
                    wait(0.1);}
            }
        else {spkr.period(0); spkr=0;}
        Thread::wait(50);   
        }
    
}


/*////////////////////// Thread pot/////////////////////////
Input: Analog in
Output: 
Read the analog value and manupulate it for further use
 //////////////////////////////////////////////////////////*/
void pot(void const *args)
{
    int k;
    while(true)   // thread loop
    {         
      if (oprate_menu[2] == SET)
       {
            k = Pot1.read_u16();  // get the value of poti 2
            k = k >> 5;          // we need only 6 bit for contrast
             lcd_mutex.lock();
             LCD.set_font((unsigned char*) Small_6);
             LCD.locate(0,10);
             LCD.printf("Pot: %d",k);
             lcd_mutex.unlock();
            //Thread::wait(500);    // wait 0.5s
       }    
       else 
       {
           lcd_mutex.lock();
             LCD.set_font((unsigned char*) Small_6);
             LCD.locate(0,10);
             LCD.printf("        ");
             lcd_mutex.unlock();
       }     
       Thread::wait(50);      
}
}
/*////////////////////// Thread pot/////////////////////////
Input:
Output: PWM output to RGB led Pin 
Multicolor LED display diffrent colors as per PWM cycle in set
 //////////////////////////////////////////////////////////*/
void rgb(void const *args)
{
      while(1) {
        if (oprate_menu[6] == SET)
        {
                
                       r = 0.5 + (rand() % 11)/20.0;
                        g = 0.5 + (rand() % 11)/20.0;
                        b = 0.5 + (rand() % 11)/20.0;
       
        }    
        
        else {r =.1;g=0;b=0;}
        Thread::wait(500); 
    }
}

/*////////////////////// Thread temp/////////////////////////
Input:
Output: PWM output to RGB led Pin 
Multicolor LED display diffrent colors as per PWM cycle in set
 //////////////////////////////////////////////////////////*/

void temp(void const *args)
{
    
  int k;
    while(true)   // thread loop
    {  
        if (oprate_menu[3] == SET)       
           {
             lcd_mutex.lock();
            LCD.set_font((unsigned char*) Small_6);
            LCD.locate(0,20);
            LCD.printf("Temp:%.1f", (float)sensor);
            lcd_mutex.unlock();
            Thread::wait(50);
           }
         else 
           {
              lcd_mutex.lock();
             LCD.set_font((unsigned char*) Small_6);
             LCD.locate(0,20);
            LCD.printf("          ");
            lcd_mutex.unlock();
            Thread::wait(50);
           }       
     
     
    Thread::wait(50);    // wait 0.5s
}
}

/*////////////////////// Thread AXIX/////////////////////////
Input: I2C data 
Output: 
Draw a circle and a buble in it. Buble move with respond to 
change in axix of board 
 //////////////////////////////////////////////////////////*/
void axix(void const *args)
{
   // Acc.init(); 
   float x=0, y=0, z=0;
    while(1)
    {   
        //int x=0,y=0;
        if (oprate_menu[4] == SET) 
        {    
            
             Acc.read_Tilt(&x, &y, &z); 
            lcd_mutex.lock();
            x = (x + MMA.x() * 32.0)/2.0;
        y = (y -(MMA.y() * 16.0))/2.0;
       // if(y>25) y = 0; //else if(y<0) y = 0;
        if(y>8) y =8; if(y<-8) y =-8; if(x>8) x =8; if(x<-8) x =-8; // confining 
        LCD.fillcircle(x+115, y+17, 2, 1); //draw bubble
        LCD.circle(115, 17, 8, 1);
        wait(.1); //time delay
        LCD.fillcircle(x+115, y+17, 2, 0); //erase bubble
           
            lcd_mutex.unlock();
           // LCD.locate(0,3);
            wait_ms(100); 
        }
        else 
        {
             lcd_mutex.lock();
              LCD.circle(115, 17, 8, 0);
             // LCD.locate(0,3);
            lcd_mutex.unlock();
          }
          Thread::wait(10);  
    }
}
 
/*////////////////////// Memory pool example and Semaphore///////////////
Output: 

 //////////////////////////////////////////////////////////*/ 
void calci(void const *args) {
    uint32_t i = 0;
    while (true) {
        calculate.wait();  //semaphore 
        i = Pot2.read_u16();; 
        i = (i>>5)/2;
        message_t *message = mpool.alloc();
        message->voltage = (i * 3.3) / 1024; 
        message->current = ((i * 3.3) / 2048);
        message->counter = i;
        queue.put(message);
        calculate.release();
        Thread::wait(100000);
    }
}          

// print the actual contrast 
int main()
{
    int j;
  //  r =0; b=0;g=0;
    LCD.cls();
     LCD.set_font((unsigned char*) Small_7);
    LCD.locate(0,0);
    LCD.printf("  embedded.zettamonk.com");
   /////////////////////////////Threads///////////////////
    Thread t1(led); //start thread1
    Thread t2(menu_sel); //start thread2
    Thread t3(spk); //start thread3
    Thread t4(pot); //start thread4
    Thread t5(rgb); //start thread4
    Thread t6(temp); //start thread4
    Thread t7(axix);
    Thread t8(calci);
    Thread t9(calci);
  ////////////////////////////////////////////////  
    while(true) {       // main is the next thread
         
         if (oprate_menu[7] == SET)
         {
                     LCD.set_font((unsigned char*) Small_7);
                    LCD.locate(0,0);
                    
                    osEvent evt = queue.get();
                    if (evt.status == osEventMessage) {
                        message_t *message = (message_t*)evt.value.p;
                        lcd_mutex.lock();
                        LCD.printf("   V:%.2fv"   , message->voltage);
                        LCD.printf(" I:%.2fA"     , message->current);
                        LCD.printf(" R: %u  ", message->counter);
                        lcd_mutex.unlock();
                        mpool.free(message);
                  
                    
                    // wait(.2);
         }
         else 
          {          LCD.set_font((unsigned char*) Small_7);
                    LCD.locate(0,0);
                    lcd_mutex.lock();
                    LCD.printf("embedded.zettamonk.com");
                     lcd_mutex.unlock(); 
          }         
         
         Thread::wait(100);   // wait 0.5s
    }
}
}
