#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx

DigitalIn button(D0);

Timer timer;

static void experiment1()
{
    unsigned int variableToHoldValue;     //declare a 32-bit variable
    unsigned char *pBytePointer;          //declare a byte-pointer

    pc.printf("\nThis is a first test...\n");
    pc.printf("that printf() works - and it does!");

    //store value in 32-bit variable
    variableToHoldValue = 0x0AC0FFEE;

    //set the byte-pointer to the beginning (first byte) of the 32-bit variable
    pBytePointer = (unsigned char *)&variableToHoldValue;

    //Test if big-endian
    if ((*pBytePointer     == 0x0A) &&
            (*(pBytePointer+1) == 0xC0) &&
            (*(pBytePointer+2) == 0xFF) &&
            (*(pBytePointer+3) == 0xEE)) {
        pc.printf("\nThe CPU is a Big-endian system\n");
    }

    //Test if little-endian instead
    else if ((*pBytePointer     == 0xEE) &&
             (*(pBytePointer+1) == 0xFF) &&
             (*(pBytePointer+2) == 0xC0) &&
             (*(pBytePointer+3) == 0x0A)) {
        pc.printf("\nThe CPU is a Little-endian system\n");
    }
    //Neither if the tests was correct – something is VERY wrong here!!!
    else {
        pc.printf("\nSomething is VERY wrong here!!!\n");
    }

    while(1)
        ;
}

static void experiment2()
{
    // Enable button
    button.mode(PullUp);

    // Enter forever loop
    while(1) {
        // Wait for button to be pressed and then released
        while(button) {
        }
        pc.printf("Button was pressed...\n");
        while(!button) {
        }
        pc.printf("and released\n");
    }
}

static void experiment3_alt1()
{
    pc.printf("This is a test of getc()...\n");
    
    // Enter forever loop
    while(1) {
        int rxChar = pc.getc();
        pc.printf("Got %c\n", rxChar);
    }
}

static void experiment3_alt2()
{
    int val = 0;
    int numChars = 0;
    pc.printf("This is a test of getc() and converts to a number...\n");
    
    // Enter forever loop
    while(1) {
        int rxChar = pc.getc();
        numChars++;
        if ((rxChar == '\r') || (rxChar == '\n') || (rxChar == ' ')) {
            // Found a separator character, print number and start over
            if (numChars > 1) {            
                pc.printf("Found %d\n", val);
            }
            numChars = 0;
            val = 0;
        }
        else if ((rxChar < '0') || (rxChar > '9')) {
            // Not a number, reset and start looking again
            pc.printf("Not a number: '%c'\n", rxChar);
            numChars = 0;
            val = 0;
        }
        else {
            // A valid number was found
            val = (val * 10) + (rxChar - '0');
            if (numChars == 9) {
                // Almost reached maximum size, print and continue
                pc.printf("Found %d\n", val);
                numChars = 0;
                val = 0;
            }
        }
    }
}

static void experiment4()
{
#define BYTES_IN_BUFF      512
#define NUM_BUFFS_TO_SEND   10

    // Change baudrate here to see what difference it makes. Don't forget
    // to change to the same value on the Host PC
    //pc.baud(115200);

    pc.printf("This is a performance test...\n");
    
    char buff[BYTES_IN_BUFF + 1];
 
    // initialize the buffer with some characters to print
    for (int i = 0; i < BYTES_IN_BUFF; i+=10) {
        for (int c = 0; c < 10; c++) {
            buff[i+c] = '0' + c;
        }
    }
 
    // puts expects the string to be null terminated
    buff[BYTES_IN_BUFF] = '\0';
    
    timer.start();
    int begin = timer.read_ms();
    for (int num = 0; num < NUM_BUFFS_TO_SEND; num++) {        
        pc.puts(buff);
    }
    int end = timer.read_ms();
    timer.stop();
 
    // print information about how much time passed and the bitrate
    printf("\n--- Sent %d bytes in %dms\n", BYTES_IN_BUFF * NUM_BUFFS_TO_SEND, end-begin);
    
    while(1)
        ;
}

int main()
{
    //experiment1();      // Detects endian
    //experiment2();      // Button
    //experiment3_alt1(); // getc
    //experiment3_alt2(); // getc with digits
    experiment4();        // performance
}