#include "mbed.h"
#include "SPI25LC080.h"

Serial pc(USBTX, USBRX);

SPI25LC080 e2prom;

#define E2PROM_START_ADDR  0
#define BUF_SIZE          20

static void experiment2()
{
    uint8_t buf[BUF_SIZE];
    char* magic = "Magic text - 654321";
    
    pc.printf("Starting E2PROM test...\n");
    
    memset(buf, 0, BUF_SIZE);

    //read from spi e2prom
    e2prom.read(E2PROM_START_ADDR, buf, BUF_SIZE);

    //write read bytes on console
    buf[19] = 0;   //null terminate string in case it is missing
    pc.printf("String in memory: '%s'\n", buf);

    //check if expected string
    if (memcmp(buf, magic, strlen(magic)) != 0) {
        memcpy(buf, magic, strlen(magic));

        //write the correct string in memory
        e2prom.write(E2PROM_START_ADDR, buf, 20);

        pc.printf("String has been written!");
    }

    printf("\nDone!");
    while(1)
        ;
}

int main()
{
    experiment2(); // E2PROM
}
