#include "mbed.h"

DigitalOut ssel(D10);
SPI spi(D11, D12, D13); // mosi, miso, sclk

Serial pc(USBTX, USBRX);

#define SEG_A   0x80
#define SEG_B   0x40
#define SEG_C   0x20
#define SEG_D   0x10
#define SEG_E   0x08
#define SEG_F   0x04
#define SEG_G   0x02
#define RDP     0x01

const uint8_t segments[16] = {
    SEG_A | SEG_B | SEG_C | SEG_D | SEG_E | SEG_F        ,  //0 = A,B,C,D,E,F
            SEG_B | SEG_C                                ,  //1 = B,C
    SEG_A | SEG_B |         SEG_D | SEG_E |         SEG_G,  //2 = A,B,D,E,G
    SEG_A | SEG_B | SEG_C | SEG_D |                 SEG_G,  //3 = A,B,C,D,G
            SEG_B | SEG_C |                 SEG_F | SEG_G,  //4 = B,C,F,G
    SEG_A |         SEG_C | SEG_D |         SEG_F | SEG_G,  //5 = A,C,D,F,G
    SEG_A |         SEG_C | SEG_D | SEG_E | SEG_F | SEG_G,  //6 = A,C,D,E,F,G
    SEG_A | SEG_B | SEG_C                                ,  //7 = A,B,C
    SEG_A | SEG_B | SEG_C | SEG_D | SEG_E | SEG_F | SEG_G,  //8 = A,B,C,D,E,F,G
    SEG_A | SEG_B | SEG_C | SEG_D |         SEG_F | SEG_G,  //9 = A,B,C,D,F,G
    SEG_A | SEG_B | SEG_C |         SEG_E | SEG_F | SEG_G,  //A = A,B,C,E,F,G
                    SEG_C | SEG_D | SEG_E | SEG_F | SEG_G,  //B = C,D,E,F,G
                            SEG_D | SEG_E |         SEG_G,  //C = D,E,G
            SEG_B | SEG_C | SEG_D | SEG_E |         SEG_G,  //D = B,C,D,E,G
    SEG_A |                 SEG_D | SEG_E | SEG_F | SEG_G,  //E = A,D,E,F,G
    SEG_A |                         SEG_E | SEG_F | SEG_G}; //F = A,E,F,G

static void send(int val)
{
    // control SSEL
    ssel = 0;
 
    spi.write(val);
 
    // control SSEL
    ssel = 1;
}

static bool readback(int val)
{
    int existing = spi.write(val);
    int expected = spi.write(0x00);
    
    if ((val & 0xff) == (expected & 0xff)) {
        return true;
    }
    return false;
}

static void experiment1_alt1()
{
    pc.printf("Starting...\n");
    
    do {
        if (readback(~segments[0xe])) {
            wait(0.5);
            if (readback(~segments[0xa])) {
                printf("readback successfull\n");
                break;
            }
        }
        printf("readback failed\n");
    } while(0);
    
    while(1)
        ;
}

static void experiment1_alt2()
{
    while(1) {
        for (int i = 0; i < 16; i++) {
            send(~segments[i]);
            wait(0.4);
        }
    }
}

static void experiment1_alt3()
{
    while(1) {
        send(~SEG_A);wait(1);
        send(~SEG_B);wait(1);
        send(~SEG_C);wait(1);
        send(~SEG_D);wait(1);
        send(~SEG_E);wait(1);
        send(~SEG_F);wait(1);
        send(~SEG_G);wait(1);
        send(~RDP);wait(1);
    }
}


int main()
{
    //experiment1_alt1(); // readback test - shift register verification
    //experiment1_alt2(); // automatic counter
    experiment1_alt3(); // running one
}
